/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;

public class LogUtil {
    protected DateFormat dateFormat;
    protected PrintStream log;
    protected boolean logging = false;
    protected boolean debug = false;

    public LogUtil() {
    }

    public LogUtil(File f) throws FileNotFoundException {
        this.setLog(new FileOutputStream(f, true));
    }

    public synchronized void setDateFormat(DateFormat df) {
        this.dateFormat = df;
    }

    public synchronized void setLog(OutputStream out) {
        if (this.log != null) {
            this.close();
        }
        if (out != null) {
            this.log = new PrintStream(out);
        }
        this.logging = true;
    }

    public synchronized void setLog(PrintStream ps) {
        if (this.log != null) {
            this.close();
        }
        this.log = ps;
        this.logging = true;
    }

    public PrintStream getLogStream() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void log(String prefix, String logEntry) {
        if (!this.logging) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        if (this.dateFormat != null) {
            sb.append(this.dateFormat.format(new Date()));
        } else {
            sb.append(new Date());
        }
        sb.append(": ");
        if (prefix != null) {
            sb.append(prefix);
        }
        sb.append(logEntry);
        if (this.log != null) {
            PrintStream printStream = this.log;
            synchronized (printStream) {
                this.log.println(sb.toString());
            }
        }
    }

    public void log(String logEntry) {
        this.log("", logEntry);
    }

    public void log(Throwable e, String prefix, String logEntry) {
        if (!this.logging) {
            return;
        }
        this.log(prefix, logEntry);
        e.printStackTrace(this.log);
        this.log.flush();
    }

    public void log(Throwable e, String logEntry) {
        this.log(e, "", logEntry);
    }

    public void log(Throwable e) {
        this.log(e, e.getMessage());
    }

    public synchronized void close() {
        this.logging = false;
        if (this.log != null) {
            this.log.flush();
            if (!this.isSystemLog()) {
                this.log.close();
            }
        }
        this.log = null;
    }

    private boolean isSystemLog() {
        return !this.log.equals(System.out) && !this.log.equals(System.err);
    }

    public void setLogging(boolean b) {
        this.logging = b;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

