/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.dao;

import com.xunlei.card.dao.BaseDao;
import com.xunlei.card.dao.IXlstatdataDao;
import com.xunlei.card.util.FlashAnalyse;
import com.xunlei.card.vo.Xlstatdata;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;

public class XlstatdataDaoImpl
extends BaseDao
implements IXlstatdataDao {
    @Override
    public Xlstatdata findXlstatdata(Xlstatdata data) {
        String sql = "select * from xlstatdata";
        String countsql = "select count(1) from xlstatdata";
        StringBuilder where = new StringBuilder(" where 1=1");
        if (data != null) {
            if (data.getSeqid() > 0L) {
                return this.getXlstatdataById(data.getSeqid());
            }
            countsql = String.valueOf(countsql) + where.toString();
            sql = String.valueOf(sql) + where.toString();
            if (this.getSingleInt(countsql) == 1) {
                return (Xlstatdata)this.queryOne(Xlstatdata.class, sql, new String[0]);
            }
        }
        return null;
    }

    @Override
    public Sheet<Xlstatdata> queryXlstatdata(Xlstatdata data, PagedFliper fliper) {
        int rowcount;
        String sql = "select * from xlstatdata";
        String countsql = "select count(1) from xlstatdata";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (data != null) {
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate = '").append(data.getBalancedate()).append("'");
            }
            if (this.isNotEmpty(data.getBizno())) {
                where.append(" and bizno = '").append(data.getBizno()).append("'");
            }
            if (this.isNotEmpty(data.getStattype())) {
                where.append(" and stattype = '").append(data.getStattype()).append("'");
            }
            if (this.isNotEmpty(data.getRtncode())) {
                where.append(" and rtncode = '").append(data.getRtncode()).append("'");
            }
            if (this.isNotEmpty(data.getStattime())) {
                where.append(" and stattime = '").append(data.getStattime()).append("'");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = String.valueOf(countsql) + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = String.valueOf(sql) + where.toString();
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = String.valueOf(sql) + " order by " + fliper.getSortColumn();
            }
            sql = String.valueOf(sql) + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(Xlstatdata.class, sql, new String[0]));
    }

    @Override
    public List<Xlstatdata> queryStatKeys(String balancedate) {
        String sql = "select distinct stattype,bizno,rtncode from xlstatdata where balancedate = '" + balancedate + "' order by stattype";
        final ArrayList<Xlstatdata> datas = new ArrayList<Xlstatdata>();
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Xlstatdata data = new Xlstatdata();
                data.setBizno(rs.getString("bizno"));
                data.setStattype(rs.getString("stattype"));
                data.setRtncode(rs.getString("rtncode"));
                datas.add(data);
            }
        });
        return datas;
    }

    public List<Xlstatdata> getStatDataByType(String balancedate, String statType) {
        String sql = "SELECT sum(runcount)as runcount,stattime from xlstatdata where balancedate = '" + balancedate + "' and stattype = '" + statType + "' group by stattime order by stattime";
        final ArrayList<Xlstatdata> datas = new ArrayList<Xlstatdata>();
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Xlstatdata data = new Xlstatdata();
                data.setRuncount(rs.getInt("runcount"));
                data.setStattime(rs.getString("stattime"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public String getDailyFlashChar(Xlstatdata data, PagedFliper fliper) {
        String flashstr = "";
        String balancedate = data.getBalancedate();
        if (this.isEmpty(balancedate)) {
            balancedate = DatetimeUtil.today();
        }
        ArrayList<String> linelist = this.getStatType(balancedate);
        int linesize = linelist.size();
        String[] rowKeys = new String[linesize];
        StringBuffer typestr = new StringBuffer();
        int i = 0;
        while (i < linesize) {
            rowKeys[i] = (String)linelist.get(i);
            if (i != linesize - 1) {
                typestr.append("'").append((String)linelist.get(i)).append("',");
            } else {
                typestr.append("'").append((String)linelist.get(i)).append("'");
            }
            ++i;
        }
        String title = String.valueOf(balancedate) + " \u7edf\u8ba1\u60c5\u51b5\u8868";
        if (linesize > 0) {
            String yName = "\u8bbf\u95ee\u91cf";
            int columnsize = 24;
            String[] columnKeys = new String[columnsize];
            double[][] copAndQtyNum = new double[linesize][columnsize];
            int k = 0;
            while (k < linesize) {
                String stattype = (String)linelist.get(k);
                Xlstatdata querybean = new Xlstatdata();
                querybean.setBalancedate(balancedate);
                querybean.setStattype(stattype);
                List<Xlstatdata> list = this.getStatDataByType(balancedate, stattype);
                int countsize = list.size();
                int a = 0;
                while (a < countsize) {
                    columnKeys[a] = String.valueOf(list.get(a).getStattime()) + ":00";
                    copAndQtyNum[k][a] = list.get(a).getRuncount();
                    ++a;
                }
                a = countsize;
                while (a < 24) {
                    columnKeys[a] = String.valueOf(a) + ":00";
                    copAndQtyNum[k][a] = 0.0;
                    ++a;
                }
                ++k;
            }
            flashstr = FlashAnalyse.createChar(columnKeys, copAndQtyNum, rowKeys, title, yName);
        } else {
            flashstr = FlashAnalyse.createChar(null, null, null, title, null);
        }
        return flashstr;
    }

    public ArrayList<String> getStatType(String balancedate) {
        final ArrayList<String> rtn = new ArrayList<String>();
        String sql = "SELECT distinct stattype from xlstatdata where balancedate ='" + balancedate + "' order by stattype";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String stattype = rs.getString("stattype");
                rtn.add(stattype);
            }
        });
        return rtn;
    }

    @Override
    public void deleteXlstatdata(Xlstatdata data) {
        if (data != null && data.getSeqid() > 0L) {
            this.deleteXlstatdataById(data.getSeqid());
        }
    }

    @Override
    public Xlstatdata getXlstatdataById(long seqid) {
        return (Xlstatdata)this.findObject(Xlstatdata.class, seqid);
    }

    @Override
    public void insertXlstatdata(Xlstatdata data) {
        this.insertObject(data);
    }

    @Override
    public void updateXlstatdata(Xlstatdata data) {
        this.updateObject(data);
    }

    @Override
    public void deleteXlstatdataById(long ... seqids) {
        this.deleteObject("xlstatdata", seqids);
    }
}

