/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.dao;

import com.xunlei.card.dao.BaseDao;
import com.xunlei.card.dao.IMakecardDao;
import com.xunlei.card.util.XLCardRuntimeException;
import com.xunlei.card.vo.Makecard;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import java.util.Collection;
import java.util.List;

public class MakecardDaoImpl
extends BaseDao
implements IMakecardDao {
    @Override
    public void insertMakecard(Makecard data) throws XLCardRuntimeException {
        this.insertObject(data);
    }

    @Override
    public void updateMakecard(Makecard data) throws XLCardRuntimeException {
        this.updateObject(data);
    }

    @Override
    public void deleteMakecard(long ... id) {
        this.deleteObject("makecard", id);
    }

    @Override
    public Makecard findMakecard(long id) {
        return (Makecard)this.findObject(Makecard.class, id);
    }

    @Override
    public List getMakecardByMakeId(String makeid) {
        String sql = "select p from Makecard as p where p.makeid = ?";
        return this.getHibernateTemplate().find(sql, (Object)makeid);
    }

    @Override
    public Sheet<Makecard> queryMakecard(Makecard idata, PagedFliper fliper) {
        String countsql;
        int rowcount;
        StringBuffer where = new StringBuffer(" where a.parno = b.parno and a.copartnerid = c.copartnerid and a.cardtypeno = d.cardtypeno ");
        if (idata != null) {
            if (this.isNotEmpty(idata.getMakeid())) {
                where.append(" and a.makeid = '").append(idata.getMakeid()).append("' ");
            }
            if (this.isNotEmpty(idata.getBatchno())) {
                where.append(" and a.batchno = '").append(idata.getBatchno()).append("' ");
            }
            if (this.isNotEmpty(idata.getCopartnerid())) {
                where.append(" and a.copartnerid = '").append(idata.getCopartnerid()).append("' ");
            }
            if (this.isNotEmpty(idata.getCardtypeno())) {
                where.append(" and a.cardtypeno = '").append(idata.getCardtypeno()).append("' ");
            }
            if (this.isNotEmpty(idata.getBalancedate())) {
                where.append(" and a.balancedate ='").append(idata.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(idata.getApplynotecd())) {
                where.append(" and a.applynotecd = '").append(idata.getApplynotecd()).append("' ");
            }
        }
        if ((rowcount = super.getSingleInt(countsql = "select count(*) from makecard a, parvaluetype b, copartners c, cardtype d " + where.toString())) == 0) {
            return Sheet.EMPTY;
        }
        String sql = "select a.*, b.parvalue, c.copartnername, d.cardtypename from makecard a, parvaluetype b, copartners c, cardtype d " + where;
        if (fliper != null) {
            sql = fliper.isNotEmptySortColumn() ? String.valueOf(sql) + " order by " + fliper.getSortColumn() : String.valueOf(sql) + "order by a.makeid ";
            sql = String.valueOf(sql) + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(Makecard.class, sql, new String[0]));
    }

    @Override
    public int getBatchNumUsed(String batchNo, long seqIdexcept) {
        String sql = "select sum(cardqty) from makecard where batchno = '" + batchNo + "'";
        if (seqIdexcept > 0L) {
            sql = String.valueOf(sql) + " and seqid != " + seqIdexcept;
        }
        return this.getJdbcTemplate().queryForInt(sql);
    }
}

