/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.dao;

import com.xunlei.card.dao.BaseDao;
import com.xunlei.card.dao.ICopthunderstatDao;
import com.xunlei.card.util.ApplicationConfigUtil;
import com.xunlei.card.util.Arith;
import com.xunlei.card.util.FlashAnalyse;
import com.xunlei.card.vo.Copthunderstat;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.RowCallbackHandler;

public class CopthunderstatDaoImpl
extends BaseDao
implements ICopthunderstatDao {
    static Logger logger = Logger.getLogger(CopthunderstatDaoImpl.class);

    @Override
    public Copthunderstat findCopthunderstat(Copthunderstat data) {
        String sql = "select * from copthunderstat";
        String countsql = "select count(1) from copthunderstat";
        StringBuilder where = new StringBuilder(" where 1=1");
        if (data != null) {
            if (data.getSeqid() > 0L) {
                return this.getCopthunderstatById(data.getSeqid());
            }
            if (this.isNotEmpty(data.getCopartnerid())) {
                where.append(" and copartnerid = '").append(data.getCopartnerid()).append("' ");
            }
            if (this.isNotEmpty(data.getBizchanneltype())) {
                where.append(" and bizchanneltype = '").append(data.getBizchanneltype()).append("' ");
            }
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate ='").append(data.getBalancedate()).append("' ");
            }
            countsql = String.valueOf(countsql) + where.toString();
            sql = String.valueOf(sql) + where.toString();
            if (this.getSingleInt(countsql) == 1) {
                return (Copthunderstat)this.queryOne(Copthunderstat.class, sql, new String[0]);
            }
        }
        return null;
    }

    @Override
    public Sheet<Copthunderstat> queryCopthunderstat(Copthunderstat data, PagedFliper fliper) {
        int rowcount;
        String sql = "select * from copthunderstat";
        String countsql = "select count(1) from copthunderstat";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (data != null) {
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate ='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>= '").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<= '").append(data.getTodate()).append("' ");
            }
            if (this.isNotEmpty(data.getCopartnerid())) {
                where.append(" and copartnerid ='").append(data.getCopartnerid()).append("' ");
            }
            if (this.isNotEmpty(data.getBizchanneltype())) {
                where.append(" and bizchanneltype = '").append(data.getBizchanneltype()).append("' ");
            }
            if (this.isNotEmpty(data.getTransfromtype())) {
                where.append(" and transfromtype = '").append(data.getTransfromtype()).append("' ");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = String.valueOf(countsql) + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = String.valueOf(sql) + where.toString();
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = String.valueOf(sql) + " order by " + fliper.getSortColumn();
            }
            sql = String.valueOf(sql) + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(Copthunderstat.class, sql, new String[0]));
    }

    private Sheet<Copthunderstat> queryCopthunderstatchart(Copthunderstat data, PagedFliper fliper) {
        int rowcount;
        String sql = "select * from copthunderstat";
        String countsql = "select count(1) from copthunderstat";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (data != null) {
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate ='").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getFromdate())) {
                where.append(" and balancedate>= '").append(data.getFromdate()).append("' ");
            }
            if (this.isNotEmpty(data.getTodate())) {
                where.append(" and balancedate<= '").append(data.getTodate()).append("' ");
            }
            if (this.isNotEmpty(data.getCopartnerid())) {
                where.append(" and copartnerid ='").append(data.getCopartnerid()).append("' ");
            }
            if (this.isNotEmpty(data.getBizchanneltype())) {
                where.append(" and bizchanneltype = '").append(data.getBizchanneltype()).append("' ");
            }
            if (this.isNotEmpty(data.getTransfromtype())) {
                where.append(" and transfromtype = '").append(data.getTransfromtype()).append("' ");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = String.valueOf(countsql) + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = String.valueOf(sql) + where.toString();
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = String.valueOf(sql) + " order by " + fliper.getSortColumn();
            }
            sql = String.valueOf(sql) + fliper.limitsql(rowcount);
        } else {
            sql = String.valueOf(sql) + " order by balancedate desc ";
        }
        return new Sheet(rowcount, (Collection)this.query(Copthunderstat.class, sql, new String[0]));
    }

    @Override
    public Copthunderstat getCopthunderstatChart(Copthunderstat data, PagedFliper fliper) {
        Sheet<Copthunderstat> sheet = this.queryCopthunderstatchart(data, fliper);
        List list = (List)sheet.getDatas();
        Copthunderstat copthunderstat = new Copthunderstat();
        int size = list.size();
        logger.debug((Object)("size=" + size));
        String title = "\u6e20\u9053\u7efc\u5408\u8868";
        if (size > 0) {
            String yName = "\u6e20\u9053\u6210\u672c";
            String[] rowKeys = new String[]{"\u5145\u503c\u96f7\u70b9", "\u6e20\u9053\u6210\u672c", "\u5b9e\u6536\u91d1\u989d", "\u6d88\u8d39\u96f7\u70b9"};
            String[] columnKeys = new String[size];
            double[][] copAndQtyNum = new double[4][size];
            int i = size - 1;
            for (Copthunderstat d : list) {
                columnKeys[i] = d.getBalancedate();
                copAndQtyNum[0][i] = d.getFacttransqty();
                copAndQtyNum[1][i] = d.getCostamt();
                copAndQtyNum[2][i] = d.getFactamt();
                copAndQtyNum[3][i] = d.getCustomeamt();
                --i;
            }
            copthunderstat.setFacttransqtyChartFile(FlashAnalyse.createChar(columnKeys, copAndQtyNum, rowKeys, title, yName));
        } else {
            copthunderstat.setFacttransqtyChartFile(FlashAnalyse.createChar(null, null, null, title, null));
        }
        return copthunderstat;
    }

    @Override
    public Copthunderstat getAddthunderChart(Copthunderstat data, PagedFliper fliper) {
        String balancedate = data.getBalancedate();
        data.setFromdate(balancedate);
        data.setTodate(balancedate);
        List<Copthunderstat> list = this.getCopartnercostStatList(data);
        Copthunderstat copthunderstat = new Copthunderstat();
        int size = list.size();
        logger.debug((Object)("size=" + size));
        String title = "\u5145\u503c\u96f7\u70b9";
        String[] rowKeys = new String[size];
        if (size > 0) {
            int index = 0;
            for (Copthunderstat item : list) {
                rowKeys[index] = item.getCopartnername();
                ++index;
            }
            String yName = "\u5145\u503c\u96f7\u70b9";
            String[] columnKeys = new String[size];
            double[][] copAndQtyNum = new double[size][size];
            int i = size - 1;
            int count = 0;
            for (Copthunderstat d : list) {
                columnKeys[i] = d.getBalancedate();
                copAndQtyNum[count][i] = d.getFacttransqty();
                ++count;
                --i;
            }
            copthunderstat.setFacttransqtyChartFile(FlashAnalyse.createChar(columnKeys, copAndQtyNum, rowKeys, title, yName));
        } else {
            copthunderstat.setFacttransqtyChartFile(FlashAnalyse.createChar(null, null, null, title, null));
        }
        return copthunderstat;
    }

    @Override
    public List<Copthunderstat> getCopartnercostStatList(Copthunderstat data) {
        ArrayList<Copthunderstat> datas = new ArrayList<Copthunderstat>();
        Copthunderstat data1 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerIdJcard(), "10");
        data1.setCopartnername("\u9a8f\u7f51 Esales");
        if ((int)data1.getFacttransqty() > 0) {
            datas.add(data1);
        }
        Copthunderstat data2 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerIdJcard(), "00");
        data2.setCopartnername("\u9a8f\u7f51 \u865a\u5361");
        if ((int)data2.getFacttransqty() > 0) {
            datas.add(data2);
        }
        Copthunderstat data3 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerIdXinshi(), "10");
        data3.setCopartnername("\u946b\u77f3 Esales");
        if ((int)data3.getFacttransqty() > 0) {
            datas.add(data3);
        }
        Copthunderstat data4 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerIdXinshi(), "00");
        data4.setCopartnername("\u946b\u77f3 \u865a\u5361");
        if ((int)data4.getFacttransqty() > 0) {
            datas.add(data4);
        }
        Copthunderstat data5 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerIdCobuy(), "10");
        data5.setCopartnername("\u8054\u5408\u8d2d\u4e70\u7f51 Esales");
        if ((int)data5.getFacttransqty() > 0) {
            datas.add(data5);
        }
        Copthunderstat data6 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerIdCobuy(), "00");
        data6.setCopartnername("\u8054\u5408\u8d2d\u4e70\u7f51 \u865a\u5361");
        if ((int)data6.getFacttransqty() > 0) {
            datas.add(data6);
        }
        Copthunderstat data7 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerId99bill(), "20");
        data7.setCopartnername("\u7f51\u94f6 \u5feb\u94b1");
        if ((int)data7.getFacttransqty() > 0) {
            datas.add(data7);
        }
        Copthunderstat data8 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerIdAlipay(), "20");
        data8.setCopartnername("\u7f51\u94f6 \u652f\u4ed8\u5b9d");
        if ((int)data8.getFacttransqty() > 0) {
            datas.add(data8);
        }
        Copthunderstat data9 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerIdYeepay(), "20");
        data9.setCopartnername("\u7f51\u94f6 \u6613\u5b9d");
        if ((int)data9.getFacttransqty() > 0) {
            datas.add(data9);
            logger.debug((Object)("\u7f51\u94f6 \u6613\u5b9d factamt" + data9.getFactamt()));
        }
        Copthunderstat data10 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerIdICBC(), "20");
        data10.setCopartnername("\u7f51\u94f6 \u5de5\u5546\u94f6\u884c");
        if ((int)data10.getFacttransqty() > 0) {
            datas.add(data10);
            logger.debug((Object)("\u7f51\u94f6 \u5de5\u5546\u94f6\u884c factamt" + data10.getFactamt()));
        }
        Copthunderstat data20 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), "000017", "20");
        data20.setCopartnername("\u7f51\u94f6 \u62db\u5546\u94f6\u884c");
        if ((int)data20.getFacttransqty() > 0) {
            datas.add(data20);
            logger.debug((Object)("\u7f51\u94f6 \u62db\u5546\u94f6\u884c factamt" + data20.getFactamt()));
        }
        Copthunderstat data11 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerId99bill(), "30");
        data11.setCopartnername("\u624b\u673a\u5145\u503c\u5361 \u79fb\u52a8\u5feb\u94b1");
        if ((int)data11.getFacttransqty() > 0) {
            datas.add(data11);
        }
        Copthunderstat data12 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerId99bill(), "50");
        data12.setCopartnername("\u624b\u673a\u5145\u503c\u5361 \u8054\u901a\u5feb\u94b1");
        if ((int)data12.getFacttransqty() > 0) {
            datas.add(data12);
        }
        Copthunderstat data13 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerIdYeepay(), "30");
        data13.setCopartnername("\u624b\u673a\u5145\u503c\u5361 \u79fb\u52a8\u6613\u5b9d");
        if ((int)data13.getFacttransqty() > 0) {
            datas.add(data13);
        }
        Copthunderstat data17 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerId19pay(), "30");
        data17.setCopartnername("\u624b\u673a\u5145\u503c\u5361 \u79fb\u52a8\u9ad8\u9633");
        if ((int)data17.getFacttransqty() > 0) {
            datas.add(data17);
        }
        Copthunderstat data14 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerIdQishun(), "40");
        data14.setCopartnername("\u9f50\u987a Esales");
        if ((int)data14.getFacttransqty() > 0) {
            datas.add(data14);
        }
        Copthunderstat data15 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), ApplicationConfigUtil.getCopartnerIdQishun(), "00");
        data15.setCopartnername("\u9f50\u987a \u865a\u5361");
        if ((int)data15.getFacttransqty() > 0) {
            datas.add(data15);
        }
        Copthunderstat data16 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), "000001", "00");
        data16.setCopartnername("\u8fc5\u96f7\u7f51\u7edc \u865a\u5361");
        if ((int)data16.getFacttransqty() > 0) {
            datas.add(data16);
        }
        Copthunderstat data18 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), "000001", "10");
        data18.setCopartnername("\u8fc5\u96f7\u7f51\u7edc Esales");
        if ((int)data18.getFacttransqty() > 0) {
            datas.add(data18);
        }
        Copthunderstat data19 = this.getCopthunderstatsum(data.getFromdate(), data.getTodate(), "999999", "10");
        data19.setCopartnername("\u79ef\u5206\u5151\u6362");
        if ((int)data19.getFacttransqty() > 0) {
            datas.add(data19);
        }
        double totalfacttransqty = 0.0;
        double totalfactamt = 0.0;
        double totalcostamt = 0.0;
        for (Copthunderstat tempdata : datas) {
            totalfacttransqty += tempdata.getFacttransqty();
            totalfactamt += tempdata.getFactamt();
            totalcostamt += tempdata.getCostamt();
        }
        if (datas.size() > 0 && this.isEmpty(data.getBalancedate())) {
            Copthunderstat totaldata = new Copthunderstat();
            totaldata.setCopartnername("\u5408\u8ba1");
            totaldata.setRate(Arith.div(totalfactamt, totalfacttransqty, 4));
            totaldata.setFacttransqty(totalfacttransqty);
            totaldata.setFactamt(Arith.round(totalfactamt, 2));
            totaldata.setCostamt(Arith.round(totalcostamt, 2));
            datas.add(totaldata);
        }
        return datas;
    }

    @Override
    public Copthunderstat getCopthunderstatsum(String fromdate, String todate, String copartnerid, String bizchanneltype) {
        final Copthunderstat data = new Copthunderstat();
        String sql = "select  sum(FactTransqty) as facttransqty,sum(Factamt) as factamt,sum(Costamt) as costamt,sum(Customeamt) as customeamt from copthunderstat  ";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (this.isNotEmpty(fromdate)) {
            where.append(" and balancedate>= '").append(StringTools.escapeSql((String)fromdate)).append("' ");
        }
        if (this.isNotEmpty(todate)) {
            where.append(" and balancedate<= '").append(StringTools.escapeSql((String)todate)).append("' ");
        }
        if (this.isNotEmpty(copartnerid)) {
            where.append(" and copartnerid ='").append(StringTools.escapeSql((String)copartnerid)).append("' ");
        }
        if (this.isNotEmpty(bizchanneltype)) {
            where.append(" and bizchanneltype = '").append(StringTools.escapeSql((String)bizchanneltype)).append("' ");
        }
        this.getJdbcTemplate().query(String.valueOf(sql) + where.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                data.setFacttransqty(rs.getDouble("facttransqty"));
                data.setFactamt(rs.getDouble("factamt"));
                data.setCostamt(rs.getDouble("costamt"));
                data.setCustomeamt(rs.getDouble("customeamt"));
                if (data.getFacttransqty() > 0.0) {
                    data.setRate(Arith.div(data.getFactamt(), data.getFacttransqty(), 4));
                }
            }
        });
        return data;
    }

    @Override
    public Copthunderstat gatherCopthunderstat(String theDate) {
        final Copthunderstat data = new Copthunderstat();
        data.setBalancedate(theDate);
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select sum(Transqty) as transqty,sum(FactTransqty)as facttransqty,sum(Factamt) as factamt,sum(Costamt) as costamt from copthunderstat ").append(" where balancedate = '").append(theDate).append("' ");
        logger.debug((Object)sqlBuffer.toString());
        this.getJdbcTemplate().query(sqlBuffer.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                data.setTransqty(rs.getDouble("transqty"));
            }
        });
        sqlBuffer.append(" and copartnerid > '000000'");
        logger.debug((Object)sqlBuffer.toString());
        this.getJdbcTemplate().query(sqlBuffer.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                data.setFacttransqty(rs.getDouble("facttransqty"));
                data.setFactamt(rs.getDouble("factamt"));
                data.setCostamt(rs.getDouble("costamt"));
                data.setCopartnerid("000000");
                data.setRate(rs.getDouble("factamt") / rs.getDouble("facttransqty"));
            }
        });
        return data;
    }

    @Override
    public Sheet<Copthunderstat> statCopThunder(String balancedate, String userid) {
        if (this.isEmpty(balancedate)) {
            return Sheet.EMPTY;
        }
        StringBuffer sqlBuffer = new StringBuffer();
        if (this.isNotEmpty(userid)) {
            sqlBuffer.append("select b.copartnerid,b.balancedate,b.bizchanneltype, b.transfromtype,abs(sum(b.transqty)) as transqty,abs(sum(b.factamt)) as factamt from accountitem b where ").append(" b.accounttype = 'C' and b.payedby<>'xlchannel' and b.BizChannelType in('00','10','40') and b.transfromtype in('01','13','61') and b.transdirection='D' and b.transtype = 'L' and b.balancedate = '").append(balancedate).append("' group by  b.copartnerid,b.balancedate,b.bizchanneltype,b.transfromtype");
            sqlBuffer.append(" union ");
            sqlBuffer.append("select a.copartnerid,a.BalanceDate,a.bizchanneltype,a.transfromtype, abs(sum(a.transqty))/2 as transqty,abs(sum(a.factamt))/2 as factamt  from accountitem a where ").append("  a.accounttype = 'C' and a.payedby<>'xlchannel' and a.BizChannelType in('20','30','50') and a.transfromtype in('61','62','63','64','65') and transdirection='C' and a.transtype = 'L' and a.balancedate = '").append(balancedate).append("' group by a.bizchanneltype,a.transfromtype,a.copartnerid ,a.BalanceDate ");
        } else {
            sqlBuffer.append("select b.copartnerid,b.balancedate,b.bizchanneltype, b.transfromtype,abs(sum(b.transqty)) as transqty,abs(sum(b.factamt)) as factamt from accountitem b where ").append(" b.accounttype = 'C' and b.BizChannelType in('00','10','40') and b.transfromtype in('01','13','61') and b.transdirection='D' and b.transtype = 'L' and b.balancedate = '").append(balancedate).append("' group by  b.copartnerid,b.balancedate,b.bizchanneltype,b.transfromtype");
            sqlBuffer.append(" union ");
            sqlBuffer.append("select a.copartnerid,a.BalanceDate,a.bizchanneltype,a.transfromtype, abs(sum(a.transqty))/2 as transqty,abs(sum(a.factamt))/2 as factamt from accountitem a where ").append("  a.accounttype = 'C' and a.BizChannelType in('20','30','50') and a.transfromtype in('61','62','63','64','65') and transdirection='C' and a.transtype = 'L' and a.balancedate = '").append(balancedate).append("' group by a.bizchanneltype,a.transfromtype,a.copartnerid ,a.BalanceDate ");
        }
        String sql = sqlBuffer.toString();
        int rowcount = this.queryToList(sql).size();
        final ArrayList datas = new ArrayList();
        if (this.isNotEmpty(userid)) {
            logger.info((Object)("sql=" + sql));
            this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    Copthunderstat data = new Copthunderstat();
                    logger.info((Object)(String.valueOf(rs.getString(1)) + "," + rs.getString(2) + "," + rs.getString(3) + "," + rs.getString(4) + "," + rs.getDouble(5) + "," + rs.getDouble(6)));
                    data.setBalancedate(rs.getString("balancedate"));
                    data.setCopartnerid(rs.getString("copartnerid"));
                    data.setBizchanneltype(rs.getString("bizchanneltype"));
                    data.setTransfromtype(rs.getString("transfromtype"));
                    data.setFacttransqty(rs.getDouble("transqty"));
                    data.setFactamt(rs.getDouble("factamt"));
                    datas.add(data);
                    logger.info((Object)("Bizchanneltype=" + data.getBizchanneltype() + ",Facttransqty=" + data.getFacttransqty() + ",Transfromtype=" + data.getTransfromtype()));
                }
            });
        } else {
            logger.info((Object)("sql=" + sql));
            this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    logger.info((Object)(String.valueOf(rs.getString(1)) + "," + rs.getString(2) + "," + rs.getString(3) + "," + rs.getString(4) + "," + rs.getDouble(5) + "," + rs.getDouble(6)));
                    Copthunderstat data = new Copthunderstat();
                    data.setBalancedate(rs.getString("balancedate"));
                    data.setCopartnerid(rs.getString("copartnerid"));
                    data.setBizchanneltype(rs.getString("bizchanneltype"));
                    data.setTransfromtype(rs.getString("transfromtype"));
                    data.setTransqty(rs.getDouble("transqty"));
                    data.setFacttransqty(rs.getDouble("transqty"));
                    data.setFactamt(rs.getDouble("factamt"));
                    datas.add(data);
                    logger.info((Object)("Bizchanneltype=" + data.getBizchanneltype() + ",Facttransqty=" + data.getFacttransqty() + ",Transfromtype=" + data.getTransfromtype()));
                }
            });
        }
        return new Sheet(rowcount, datas);
    }

    @Override
    public void deleteCopthunderstat(Copthunderstat data) {
        if (data != null && data.getSeqid() > 0L) {
            this.deleteCopthunderstatById(data.getSeqid());
        }
    }

    @Override
    public Copthunderstat getCopthunderstatById(long seqid) {
        return (Copthunderstat)this.findObject(Copthunderstat.class, seqid);
    }

    @Override
    public void insertCopthunderstat(Copthunderstat data) {
        this.insertObject(data);
    }

    @Override
    public void updateCopthunderstat(Copthunderstat data) {
        this.updateObject(data);
    }

    @Override
    public void deleteCopthunderstatById(long ... seqids) {
        this.deleteObject("copthunderstat", seqids);
    }
}

