/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.dao;

import com.xunlei.card.dao.BaseDao;
import com.xunlei.card.dao.IAdvsDao;
import com.xunlei.card.vo.Advs;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;

public class AdvsDaoImpl
extends BaseDao
implements IAdvsDao {
    @Override
    public List<Advs> getAllAdvs() {
        String sql = "select adv from Advs as adv";
        return this.getHibernateTemplate().find(sql);
    }

    @Override
    public Advs findAdvs(Advs data) {
        String sql = "select * from advs";
        String countsql = "select count(1) from advs";
        StringBuilder where = new StringBuilder(" where 1=1");
        if (data != null) {
            if (data.getSeqid() > 0L) {
                return this.getAdvsById(data.getSeqid());
            }
            countsql = String.valueOf(countsql) + where.toString();
            sql = String.valueOf(sql) + where.toString();
            if (this.getSingleInt(countsql) == 1) {
                return (Advs)this.queryOne(Advs.class, sql, new String[0]);
            }
        }
        return null;
    }

    @Override
    public Sheet<Advs> queryAdvs(Advs data, PagedFliper fliper) {
        int rowcount;
        String sql = "select a.* , d.domainname as domainname from advs a left join domains d on a.domainno = d.domainno ";
        String countsql = "select count(1) from advs a left join domains d on a.domainno = d.domainno ";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (data != null) {
            if (this.isNotEmpty(data.getAdvtype())) {
                where.append(" and a.advtype = '").append(data.getAdvtype()).append("' ");
            }
            if (this.isNotEmpty(data.getDomainno())) {
                where.append(" and a.domainno = '").append(data.getDomainno()).append("' ");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = String.valueOf(countsql) + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = String.valueOf(sql) + where.toString();
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = String.valueOf(sql) + " order by " + fliper.getSortColumn();
            }
            sql = String.valueOf(sql) + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(Advs.class, sql, new String[]{"domainname"}));
    }

    @Override
    public void deleteAdvs(Advs data) {
        if (data != null && data.getSeqid() > 0L) {
            this.deleteAdvsById(data.getSeqid());
        }
    }

    @Override
    public Advs getAdvsById(long seqid) {
        return (Advs)this.findObject(Advs.class, seqid);
    }

    @Override
    public void insertAdvs(Advs data) {
        this.insertObject(data);
    }

    @Override
    public void updateAdvs(Advs data) {
        this.updateObject(data);
    }

    @Override
    public void deleteAdvsById(long ... seqids) {
        this.deleteObject("advs", seqids);
    }

    @Override
    public List<Advs> getAdvsByType(int num, String domian, String type) {
        final ArrayList<Advs> datas = new ArrayList<Advs>();
        String sql = "select * from advs where InUse = 1 and ExpireTime >='" + DatetimeUtil.today() + "' and domainno = '" + domian + "' and AdvType = '" + type + "' order by displayorder ";
        if (num != -1) {
            sql = String.valueOf(sql) + "limit " + num;
        }
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Advs adata = new Advs();
                adata.setSeqid(rs.getLong("seqid"));
                adata.setDomainno(rs.getString("domainno"));
                adata.setAdvtype(rs.getString("advtype"));
                adata.setAdvtitle(rs.getString("advtitle"));
                adata.setAdvurl(rs.getString("advurl"));
                adata.setPicurl(rs.getString("picurl"));
                adata.setInuse(rs.getShort("inuse"));
                adata.setDisplayorder(rs.getInt("displayorder"));
                adata.setExpiretime(rs.getString("expiretime"));
                adata.setRemark(rs.getString("remark"));
                adata.setInputby(rs.getString("inputby"));
                adata.setInputtime(rs.getString("inputtime"));
                adata.setEditby(rs.getString("editby"));
                adata.setEdittime(rs.getString("edittime"));
                datas.add(adata);
            }
        });
        return datas;
    }

    @Override
    public List<Advs> getAdvsInDomains(int num, String[] domains, String[] advTypes) {
        final ArrayList<Advs> datas = new ArrayList<Advs>();
        String domainIn = AdvsDaoImpl.uniteForIn((String[])domains);
        String advtypeIn = AdvsDaoImpl.uniteForIn((String[])advTypes);
        String sql = "select * from advs where InUse = 1 and ExpireTime >='" + DatetimeUtil.today() + "' and domainno in " + domainIn + " and AdvType in " + advtypeIn + " order by displayorder ";
        if (num != -1) {
            sql = String.valueOf(sql) + "limit " + num;
        }
        logger.info((Object)("sql = " + sql));
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Advs adata = new Advs();
                adata.setSeqid(rs.getLong("seqid"));
                adata.setDomainno(rs.getString("domainno"));
                adata.setAdvtype(rs.getString("advtype"));
                adata.setAdvtitle(rs.getString("advtitle"));
                adata.setAdvurl(rs.getString("advurl"));
                adata.setPicurl(rs.getString("picurl"));
                adata.setInuse(rs.getShort("inuse"));
                adata.setDisplayorder(rs.getInt("displayorder"));
                adata.setExpiretime(rs.getString("expiretime"));
                adata.setRemark(rs.getString("remark"));
                adata.setInputby(rs.getString("inputby"));
                adata.setInputtime(rs.getString("inputtime"));
                adata.setEditby(rs.getString("editby"));
                adata.setEdittime(rs.getString("edittime"));
                datas.add(adata);
            }
        });
        return datas;
    }
}

