/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.dao;

import com.xunlei.card.dao.BaseDao;
import com.xunlei.card.dao.IAccountitemDao;
import com.xunlei.card.vo.Accountitem;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.RowCallbackHandler;

public class AccountitemDaoImpl
extends BaseDao
implements IAccountitemDao {
    static Logger log = Logger.getLogger(AccountitemDaoImpl.class);

    @Override
    public Accountitem findAccountitem(Accountitem data) {
        String sql = "select * from accountitem";
        String countsql = "select count(1) from accountitem";
        StringBuilder where = new StringBuilder(" where 1=1");
        if (data != null) {
            if (data.getSeqid() > 0L) {
                return this.getAccountitemById(data.getSeqid());
            }
            countsql = String.valueOf(countsql) + where.toString();
            sql = String.valueOf(sql) + where.toString();
            if (this.getSingleInt(countsql) == 1) {
                return (Accountitem)this.queryOne(Accountitem.class, sql, new String[0]);
            }
        }
        return null;
    }

    @Override
    public Sheet<Accountitem> queryAccountitem(Accountitem data, PagedFliper fliper) {
        int rowcount;
        String sql = "select * from accountitem";
        String countsql = "select count(1) from accountitem";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (data != null) {
            if (this.isNotEmpty(data.getBalancedate())) {
                where.append(" and balancedate = '").append(data.getBalancedate()).append("' ");
            }
            if (this.isNotEmpty(data.getPayedby())) {
                where.append(" and  payedby = '").append(data.getPayedby()).append("' ");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = String.valueOf(countsql) + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = String.valueOf(sql) + where.toString();
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = String.valueOf(sql) + " order by " + fliper.getSortColumn();
            }
            sql = String.valueOf(sql) + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(Accountitem.class, sql, new String[0]));
    }

    @Override
    public void deleteAccountitem(Accountitem data) {
        if (data != null && data.getSeqid() > 0L) {
            this.deleteAccountitemById(data.getSeqid());
        }
    }

    @Override
    public Accountitem getAccountitemById(long seqid) {
        return (Accountitem)this.findObject(Accountitem.class, seqid);
    }

    @Override
    public void insertAccountitem(Accountitem data) {
        this.insertObject(data);
    }

    @Override
    public void updateAccountitem(Accountitem data) {
        this.updateObject(data);
    }

    @Override
    public void deleteAccountitemById(long ... seqids) {
        this.deleteObject("accountitem", seqids);
    }

    @Override
    public List<Accountitem> getAccountitemSumList(Accountitem idata) {
        final ArrayList<Accountitem> datas = new ArrayList<Accountitem>();
        StringBuffer sql = new StringBuffer();
        sql.append("select copartnerid, accountno, itemno, transtype, transdirection, sum(transqty) as transqty from accountitem where 1=1 ");
        if (this.isNotEmpty(idata.getBalancedate())) {
            sql.append(" and balancedate = '").append(idata.getBalancedate()).append("' ");
        }
        if (this.isNotEmpty(idata.getItemno())) {
            sql.append(" and itemno = '").append(idata.getItemno()).append("' ");
        }
        if (this.isNotEmpty(idata.getChannelno())) {
            sql.append(" and channelno = '").append(idata.getChannelno()).append("' ");
        }
        if (this.isNotEmpty(idata.getTradesn())) {
            sql.append(" and tradesn = '").append(idata.getTradesn()).append("' ");
        }
        if (this.isNotEmpty(idata.getAccounttype())) {
            sql.append(" and accounttype = '").append(idata.getAccounttype()).append("' ");
        }
        if (this.isNotEmpty(idata.getAccountno())) {
            sql.append(" and accountno = '").append(idata.getAccountno()).append("' ");
        }
        if (this.isNotEmpty(idata.getTranstype())) {
            sql.append(" and transtype = '").append(idata.getTranstype()).append("' ");
        }
        if (this.isNotEmpty(idata.getTransdirection())) {
            sql.append(" and transdirection = '").append(idata.getTransdirection()).append("' ");
        }
        sql.append(" group by copartnerid, accountno, itemno, transtype, transdirection");
        this.getJdbcTemplate().query(sql.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Accountitem data = new Accountitem();
                data.setCopartnerid(rs.getString("copartnerid"));
                data.setAccountno(rs.getString("accountno"));
                data.setItemno(rs.getString("itemno"));
                data.setTranstype(rs.getString("transtype"));
                data.setTransdirection(rs.getString("transdirection"));
                data.setTransqty(rs.getInt("transqty"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public List<Accountitem> getRechargePaihangbangList(Accountitem idata) {
        final ArrayList<Accountitem> datas = new ArrayList<Accountitem>();
        StringBuffer sql = new StringBuffer();
        sql.append("select payedby, sum(transqty) as transqty from accountitem where 1=1 ");
        if (this.isNotEmpty(idata.getBalancedate())) {
            sql.append(" and balancedate = '").append(idata.getBalancedate()).append("' ");
        }
        sql.append(" and transdirection = 'C' and transfromtype in ('01', '61', '13')");
        sql.append(" group by payedby order by transqty desc limit 200");
        this.getJdbcTemplate().query(sql.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Accountitem data = new Accountitem();
                data.setPayedby(rs.getString("payedby"));
                data.setTransqty(rs.getInt("transqty"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public double getAccountitemSum(Accountitem idata) {
        String val;
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(transqty) from accountitem where 1=1 ");
        if (this.isNotEmpty(idata.getBalancedate())) {
            sql.append(" and BalanceDate = '").append(idata.getBalancedate()).append("' ");
        }
        if (this.isNotEmpty(idata.getAccounttype())) {
            sql.append(" and accounttype = '").append(idata.getAccounttype()).append("' ");
        }
        if (this.isNotEmpty(idata.getTransdirection())) {
            sql.append(" and TransDirection = '").append(idata.getTransdirection()).append("' ");
        }
        if (this.isNotEmpty(idata.getAccountno())) {
            sql.append(" and accountno = '").append(idata.getAccountno()).append("' ");
        }
        if (this.isNotEmpty(idata.getItemno())) {
            sql.append(" and itemno = '").append(idata.getItemno()).append("' ");
        }
        if (this.isNotEmpty(idata.getTranstype())) {
            sql.append(" and transtype = '").append(idata.getTranstype()).append("' ");
        }
        if ((val = (String)this.getJdbcTemplate().queryForObject(sql.toString(), String.class)) == null) {
            return 0.0;
        }
        return Double.parseDouble(val);
    }

    @Override
    public List<Accountitem> getCopartnerStatList(Accountitem idata) {
        final ArrayList<Accountitem> datas = new ArrayList<Accountitem>();
        int cardcount = 0;
        int directcount = 0;
        int telcount = 0;
        int concount = 0;
        StringBuffer sql1 = new StringBuffer();
        sql1.append("select b.copartnername,a.bizchanneltype, abs(sum(a.transqty)) as transqty from accountitem a, copartners b where ");
        sql1.append(" a.copartnerid = b.copartnerid and a.accounttype = 'C' and a.BizChannelType in('00','10','40') and a.transfromtype in('01','13','61') and transdirection='D' and a.transtype = 'L' ");
        if (this.isNotEmpty(idata.getFromdate())) {
            sql1.append(" and BalanceDate >= '").append(idata.getFromdate()).append("' ");
        }
        if (this.isNotEmpty(idata.getTodate())) {
            sql1.append(" and BalanceDate <= '").append(idata.getTodate()).append("' ");
        }
        sql1.append("  group by  b.copartnername,a.bizchanneltype order by a.bizchanneltype");
        log.debug((Object)(" sql1=" + sql1.toString()));
        this.getJdbcTemplate().query(sql1.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Accountitem data = new Accountitem();
                String bizchanneltype = rs.getString("bizchanneltype");
                if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("00")) {
                    data.setCopartnername("\u70b9\u5361 " + rs.getString("copartnername"));
                } else if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("10")) {
                    data.setCopartnername("\u76f4\u5145 " + rs.getString("copartnername"));
                } else if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("40")) {
                    data.setCopartnername("\u58f0\u8baf\u7535\u8bdd " + rs.getString("copartnername"));
                }
                data.setTransqty(rs.getDouble("transqty"));
                data.setStyleclass("");
                datas.add(data);
            }
        });
        for (Accountitem item : datas) {
            if (item.getCopartnername().startsWith("\u70b9\u5361")) {
                ++cardcount;
            }
            if (item.getCopartnername().startsWith("\u76f4\u5145")) {
                ++directcount;
            }
            if (item.getCopartnername().startsWith("\u58f0\u8baf\u7535\u8bdd")) {
                ++telcount;
            }
            if (!item.getCopartnername().startsWith("\u8054\u901a\u5361")) continue;
            ++concount;
        }
        final int indexCard = cardcount;
        int directsize = 0;
        directsize = cardcount > 0 ? cardcount + directcount + 1 : cardcount + directcount;
        final int indexdriect = directsize;
        int telsize = 0;
        telsize = directcount > 0 ? directsize + telcount + 1 : directsize + telcount;
        final int indextel = telsize;
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select a.BizChannelType,abs(sum(a.transqty)) as transqty from accountitem a where ");
        sql2.append(" a.accounttype = 'C' and a.BizChannelType in('00','10','40') and a.transfromtype in('01','13','61') and transdirection='D' and a.transtype = 'L' ");
        if (this.isNotEmpty(idata.getFromdate())) {
            sql2.append(" and BalanceDate >= '").append(idata.getFromdate()).append("' ");
        }
        if (this.isNotEmpty(idata.getTodate())) {
            sql2.append(" and BalanceDate <= '").append(idata.getTodate()).append("' ");
        }
        sql2.append("  group by a.bizchanneltype order by a.bizchanneltype ");
        log.debug((Object)("\u865a\u62df\u70b9\u5361,\u76f4\u5145\u5c0f\u8ba1=" + sql2.toString()));
        this.getJdbcTemplate().query(sql2.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Accountitem data = new Accountitem();
                String bizchanneltype = rs.getString("bizchanneltype");
                if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("00")) {
                    data.setCopartnername("(\u5c0f\u8ba1)\u4ee3\u7406\u5546\u865a\u62df\u70b9\u5361");
                } else if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("10")) {
                    data.setCopartnername("(\u5c0f\u8ba1)\u4ee3\u7406\u5546\u76f4\u5145");
                } else if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("40")) {
                    data.setCopartnername("(\u5c0f\u8ba1)\u58f0\u8baf\u7535\u8bdd");
                }
                data.setTransqty(rs.getDouble("transqty"));
                data.setStyleclass("stylereportsum");
                if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("00")) {
                    datas.add(indexCard, data);
                } else if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("10")) {
                    datas.add(indexdriect, data);
                } else if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("40")) {
                    datas.add(indextel, data);
                }
            }
        });
        int bankstart = datas.size();
        StringBuffer sql3 = new StringBuffer();
        sql3.append("select a.bizchanneltype,a.transfromtype, abs(sum(a.transqty)) as transqty from accountitem a where ");
        sql3.append(" a.accounttype = 'C' and a.BizChannelType in('20','30','50') and a.transfromtype in('61','62','63','64','65') and transdirection='C' and a.transtype = 'L' ");
        if (this.isNotEmpty(idata.getFromdate())) {
            sql3.append(" and BalanceDate >= '").append(idata.getFromdate()).append("' ");
        }
        if (this.isNotEmpty(idata.getTodate())) {
            sql3.append(" and BalanceDate <= '").append(idata.getTodate()).append("' ");
        }
        sql3.append("  group by a.bizchanneltype,a.transfromtype");
        log.debug((Object)("\u7f51\u94f6,\u795e\u5dde\u884c=" + sql3.toString()));
        this.getJdbcTemplate().query(sql3.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Accountitem data = new Accountitem();
                String bizchanneltype = rs.getString("bizchanneltype");
                String fromtype = rs.getString("transfromtype");
                if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("20")) {
                    if (AccountitemDaoImpl.this.isNotEmpty(fromtype) && fromtype.equals("61")) {
                        data.setCopartnername("\u7f51\u94f6 \u5feb\u94b1");
                    }
                    if (AccountitemDaoImpl.this.isNotEmpty(fromtype) && fromtype.equals("62")) {
                        data.setCopartnername("\u7f51\u94f6 \u6613\u5b9d");
                    }
                    if (AccountitemDaoImpl.this.isNotEmpty(fromtype) && fromtype.equals("63")) {
                        data.setCopartnername("\u7f51\u94f6 \u652f\u4ed8\u5b9d");
                    }
                    if (AccountitemDaoImpl.this.isNotEmpty(fromtype) && fromtype.equals("65")) {
                        data.setCopartnername("\u7f51\u94f6 \u5de5\u5546\u94f6\u884c");
                    }
                } else if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("30")) {
                    if (AccountitemDaoImpl.this.isNotEmpty(fromtype) && fromtype.equals("61")) {
                        data.setCopartnername("\u795e\u5dde\u884c \u5feb\u94b1");
                    }
                    if (AccountitemDaoImpl.this.isNotEmpty(fromtype) && fromtype.equals("62")) {
                        data.setCopartnername("\u795e\u5dde\u884c \u6613\u5b9d");
                    }
                    if (AccountitemDaoImpl.this.isNotEmpty(fromtype) && fromtype.equals("64")) {
                        data.setCopartnername("\u795e\u5dde\u884c \u9ad8\u9633\u6377\u8fc5");
                    }
                } else if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("50")) {
                    data.setCopartnername("\u8054\u901a\u5361 \u5feb\u94b1");
                }
                data.setTransqty(rs.getDouble("transqty") / 2.0);
                datas.add(data);
            }
        });
        int bank = 0;
        int szx = 0;
        int ltk = 0;
        for (Accountitem item : datas) {
            if (item.getCopartnername().startsWith("\u7f51\u94f6")) {
                ++bank;
            }
            if (item.getCopartnername().startsWith("\u795e\u5dde\u884c")) {
                ++szx;
            }
            if (!item.getCopartnername().startsWith("\u8054\u901a\u5361")) continue;
            ++ltk;
        }
        final int bankindex = bankstart + bank;
        final int szxindex = bankindex + szx + 1;
        StringBuffer sql5 = new StringBuffer();
        sql5.append("select a.bizchanneltype, abs(sum(a.transqty)) as transqty from accountitem a where ");
        sql5.append(" a.accounttype = 'C' and a.BizChannelType in('20','30','50') and a.transfromtype in('61','62','63','64','65') and transdirection='C' and a.transtype = 'L' ");
        if (this.isNotEmpty(idata.getFromdate())) {
            sql5.append(" and BalanceDate >= '").append(idata.getFromdate()).append("' ");
        }
        if (this.isNotEmpty(idata.getTodate())) {
            sql5.append(" and BalanceDate <= '").append(idata.getTodate()).append("' ");
        }
        sql5.append("  group by a.bizchanneltype ");
        log.debug((Object)("\u5408\u8ba1\u7f51\u94f6,\u795e\u5dde\u884c=" + sql5.toString()));
        this.getJdbcTemplate().query(sql5.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Accountitem data = new Accountitem();
                String bizchanneltype = rs.getString("bizchanneltype");
                if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("20")) {
                    data.setCopartnername("(\u5c0f\u8ba1)\u7f51\u94f6");
                } else if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("30")) {
                    data.setCopartnername("(\u5c0f\u8ba1)\u795e\u5dde\u884c");
                } else if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("50")) {
                    data.setCopartnername("(\u5c0f\u8ba1)\u8054\u901a\u5361");
                }
                data.setTransqty(rs.getDouble("transqty") / 2.0);
                if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("20")) {
                    datas.add(bankindex, data);
                } else if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("30")) {
                    datas.add(szxindex, data);
                } else if (AccountitemDaoImpl.this.isNotEmpty(bizchanneltype) && bizchanneltype.equals("50")) {
                    datas.add(data);
                }
            }
        });
        int total = 0;
        for (Accountitem data : datas) {
            if (!data.getCopartnername().startsWith("(\u5c0f\u8ba1)")) continue;
            total = (int)((double)total + data.getTransqty());
        }
        Accountitem totaldata = new Accountitem();
        totaldata.setCopartnername("\u603b\u8ba1");
        totaldata.setTransqty(total);
        if (datas.size() > 0) {
            datas.add(totaldata);
        }
        return datas;
    }

    @Override
    public List<Accountitem> getCopartnerStatNewList(Accountitem idata) {
        final ArrayList<Accountitem> datas = new ArrayList<Accountitem>();
        StringBuilder sql = new StringBuilder();
        sql.append("select b.copartnername as 'copartnername',c.bizchanneltype, sum(c.transqty) as transqty from copthunderstat c , copartners b  where c.copartnerid = b.copartnerid  ");
        if (this.isNotEmpty(idata.getFromdate())) {
            sql.append(" and balancedate>= '").append(idata.getFromdate()).append("' ");
        }
        if (this.isNotEmpty(idata.getTodate())) {
            sql.append(" and balancedate<= '").append(idata.getTodate()).append("' ");
        }
        sql.append(" group by  b.copartnername,c.bizchanneltype order by c.bizchanneltype ");
        this.getJdbcTemplate().query(sql.toString(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Accountitem data = new Accountitem();
                data.setBizchanneltype(rs.getString("bizchanneltype"));
                data.setTransqty(rs.getDouble("transqty"));
                data.setCopartnername(rs.getString("copartnername"));
                datas.add(data);
            }
        });
        return datas;
    }
}

