/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.bo;

import com.xunlei.bonusbiz.util.HtmlParser;
import com.xunlei.card.bo.BaseBo;
import com.xunlei.card.bo.IPlacardsBo;
import com.xunlei.card.dao.IPlacardsDao;
import com.xunlei.card.facade.IFacade;
import com.xunlei.card.util.ApplicationConfigUtil;
import com.xunlei.card.util.PayCenter2AppConfigUtil;
import com.xunlei.card.util.Utility;
import com.xunlei.card.util.VmUtil;
import com.xunlei.card.vo.Advs;
import com.xunlei.card.vo.Placards;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class PlacardsBoImpl
extends BaseBo
implements IPlacardsBo {
    private static Logger logger = Logger.getLogger(PlacardsBoImpl.class);
    private IPlacardsDao placardsDao;
    private static String jsonPath = String.valueOf(PayCenter2AppConfigUtil.getJsonPath()) + File.separator;

    @Override
    public void deletePlacardsById(long ... seqids) {
        this.getPlacardsDao().deletePlacardsById(seqids);
    }

    @Override
    public void deletePlacards(Placards data) {
        this.getPlacardsDao().deletePlacards(data);
    }

    @Override
    public Placards findPlacards(Placards data) {
        return this.getPlacardsDao().findPlacards(data);
    }

    @Override
    public Placards getPlacardsById(long seqid) {
        return this.getPlacardsDao().getPlacardsById(seqid);
    }

    @Override
    public void insertPlacards(Placards data) {
        this.getPlacardsDao().insertPlacards(data);
    }

    @Override
    public Sheet<Placards> queryPlacards(Placards data, PagedFliper fliper, int top) {
        return this.getPlacardsDao().queryPlacards(data, fliper, top);
    }

    @Override
    public void updatePlacards(Placards data) {
        this.getPlacardsDao().updatePlacards(data);
    }

    @Override
    public List<Placards> getAllPlacards() {
        return this.getPlacardsDao().getAllPlacards();
    }

    @Override
    public List<Placards> getPlacardByPlacardId(String id) {
        return this.getPlacardsDao().getPlacardByPlacardId(id);
    }

    @Override
    public List<Placards> getPlacardsByCardType(int num, String flatno, String cardtype) {
        return this.getPlacardsDao().getPlacardsByCardType(num, flatno, cardtype);
    }

    public IPlacardsDao getPlacardsDao() {
        return this.placardsDao;
    }

    public void setPlacardsDao(IPlacardsDao placardsDao) {
        this.placardsDao = placardsDao;
    }

    @Override
    public void generateIndexPlacardsPages() throws Exception {
        Placards placards = new Placards();
        placards.setInuse((short)1);
        placards.setCardtype("001");
        placards.setFlatno("02");
        List list = (List)IFacade.INSTANCE.queryPlacards(placards, null, 3).getDatas();
        for (Placards placard : list) {
            if (placard.getContentflag() == 0) {
                placard.setCardlinkurl("./placards/placards" + placard.getCardid() + ".html");
            }
            String title = Utility.getGBKGiveLengthBytes(placard.getTitle(), 18);
            placard.setTitle(title);
            logger.debug((Object)("title=" + (String)title + "----placard.getTitle()=" + placard.getTitle()));
        }
        List<Advs> rightAdvs = IFacade.INSTANCE.getAdvsByType(4, "004", "1");
        for (Advs adv : rightAdvs) {
            adv.setPicurl("./pictures/pguanggao/" + adv.getPicurl());
            String title = Utility.getGBKGiveLengthBytes(adv.getAdvtitle(), 14);
            adv.setAdvtitle(title);
            String remark = Utility.getGBKGiveLengthBytes(adv.getRemark(), 24);
            adv.setRemark(remark);
            logger.debug((Object)("title=" + title + "----adv.getAdvtitle()=" + adv.getAdvtitle()));
            logger.debug((Object)("remark=" + remark + "----adv.getRemark()=" + adv.getRemark()));
        }
        VelocityContext context = new VelocityContext();
        context.put("placardslist", (Object)list);
        context.put("rightAdvs", rightAdvs);
        Utility.velocityPay2File(context, ApplicationConfigUtil.getStaticPagePay2Path(), "payplacards.vm", "placards.html");
        context = new VelocityContext();
        List<Advs> bottomAdvs = IFacade.INSTANCE.getAdvsByType(5, "005", "1");
        for (Advs adv : bottomAdvs) {
            adv.setPicurl("./pictures/pguanggao/" + adv.getPicurl());
            String title = Utility.getGBKGiveLengthBytes(adv.getAdvtitle(), 14);
            adv.setAdvtitle(title);
        }
        context.put("bottomAdvs", bottomAdvs);
        try {
            Utility.velocityPay2File(context, ApplicationConfigUtil.getStaticPagePay2Path(), "foot.vm", "foot.html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void genBulletinJson() throws Exception {
        StringBuilder cardType = new StringBuilder();
        List list = LibClassM.getLibClassDList((String)"PlacardType");
        int len = list.size();
        int i = 0;
        while (i < len) {
            String itemNo = ((LibClassD)list.get(i)).getItemno();
            if (itemNo.indexOf("_h") > 0 || itemNo.indexOf("_w") > 0) {
                cardType.append("'").append(((LibClassD)list.get(i)).getItemno()).append("',");
            }
            ++i;
        }
        int lastComma = cardType.lastIndexOf(",");
        String type = cardType.substring(0, lastComma);
        List<Placards> placardsList = IFacade.INSTANCE.getPlacardsByCardType(100, "PayCenter2.0", type);
        for (Placards one : placardsList) {
            String time = one.getIssuetime().substring(5, 10).replace("-", ".");
            one.setIssuetime(time);
            String content = HtmlParser.modifyBnwaresWareDesp((String)one.getCardcontent());
            one.setCardcontent(content);
        }
        VelocityContext ctx = new VelocityContext();
        ctx.put("placardsList", placardsList);
        String json = VmUtil.getVmConent((Context)ctx, PayCenter2AppConfigUtil.getVmPath(), "bulletin.vm");
        VmUtil.createFile(String.valueOf(jsonPath) + "bulletin.json", json);
    }

    @Override
    public void genActivitiesJson() throws Exception {
        Placards placards = new Placards();
        placards.setInuse((short)1);
        placards.setFlatno("PayCenter2.0");
        placards.setCardtype("001");
        PagedFliper fliper = new PagedFliper();
        fliper.setSortColumn("displayorder desc");
        Collection placardsList = IFacade.INSTANCE.queryPlacards(placards, null, 5).getDatas();
        this.genPlacardsContentHtml();
        for (Placards one : placardsList) {
            String time = one.getIssuetime().substring(5, 10).replace("-", ".");
            one.setIssuetime(time);
            String content = HtmlParser.modifyBnwaresWareDesp((String)one.getCardcontent());
            if (one.getTitle().length() > 13) {
                one.setTitle(String.valueOf(one.getTitle().substring(0, 11)) + "...");
            }
            one.setCardcontent(content);
        }
        VelocityContext ctx = new VelocityContext();
        ctx.put("placardsList", (Object)placardsList);
        String json = VmUtil.getVmConent((Context)ctx, PayCenter2AppConfigUtil.getVmPath(), "activities.vm");
        VmUtil.createFile(String.valueOf(jsonPath) + "activities.json", json);
    }

    private void genPlacardsContentHtml() {
        List<Placards> list = this.getPlacardsByCardType(-1, "PayCenter2.0", "001");
        VelocityContext context = new VelocityContext();
        for (Placards newsPlacard : list) {
            if (newsPlacard.getTitle().length() > 40) {
                newsPlacard.setTitle(String.valueOf(newsPlacard.getTitle().substring(0, 38)) + "...");
            } else {
                newsPlacard.setTitle(newsPlacard.getTitle());
            }
            context.put("newsPlacard", (Object)newsPlacard);
            try {
                String placardcontentPath = String.valueOf(PayCenter2AppConfigUtil.getPlacardContentHtmlPath()) + File.separator;
                String html = VmUtil.getVmConent((Context)context, PayCenter2AppConfigUtil.getVmPath(), "placardscontent.vm");
                VmUtil.createFile(String.valueOf(placardcontentPath) + newsPlacard.getCardid() + ".html", html);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void genThunderAdvJson() throws Exception {
        String[] domains = new String[]{"008"};
        Advs advs = new Advs();
        advs.setInuse((short)1);
        PagedFliper fliper = new PagedFliper();
        fliper.setSortColumn("displayorder desc");
        String[] advTypes = new String[]{"0", "1"};
        List<Advs> advList = IFacade.INSTANCE.getAdvsInDomains(1, domains, advTypes);
        VelocityContext context = new VelocityContext();
        context.put("advList", advList);
        String json = VmUtil.getVmConent((Context)context, PayCenter2AppConfigUtil.getVmPath(), "advertisement.vm");
        VmUtil.createFile(String.valueOf(jsonPath) + "advertisement.json", json);
    }

    @Override
    public void genIndexAdvJson() throws Exception {
        String[] domains = new String[]{"007"};
        Advs advs = new Advs();
        advs.setInuse((short)1);
        PagedFliper fliper = new PagedFliper();
        fliper.setSortColumn("displayorder desc");
        String[] advTypes = new String[]{"0", "1"};
        List<Advs> advList = IFacade.INSTANCE.getAdvsInDomains(5, domains, advTypes);
        VelocityContext context = new VelocityContext();
        context.put("advList", advList);
        String json = VmUtil.getVmConent((Context)context, PayCenter2AppConfigUtil.getVmPath(), "indexad.vm");
        VmUtil.createFile(String.valueOf(jsonPath) + "indexad.json", json);
    }

    @Override
    public void generateHelpListPages() throws Exception {
        List<Placards> list = this.getPlacardsByCardType(-1, "02", "('003')");
        for (Placards questionPlacard : list) {
            if (questionPlacard.getTitle().length() > 25) {
                questionPlacard.setLabels(String.valueOf(questionPlacard.getTitle().substring(0, 23)) + "...");
            } else {
                questionPlacard.setLabels(questionPlacard.getTitle());
            }
            if (questionPlacard.getContentflag() != 0) continue;
            questionPlacard.setCardlinkurl("help" + questionPlacard.getCardid() + ".html");
        }
        VelocityContext context = new VelocityContext();
        context.put("placardslist", list);
        try {
            Utility.velocityPay2File(context, ApplicationConfigUtil.getStaticPagePay2Path(), "placardslist.vm", "js" + File.separator + "help.js");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void generateBankPages() throws Exception {
        List list = LibClassM.getLibClassDList((String)"BankPageIndex");
        int ext99billrate = 0;
        int extyeepayrate = 0;
        int extalipayrate = 0;
        for (LibClassD ld : list) {
            if (ld.getItemno().equals("Ext99bill")) {
                ext99billrate = Integer.parseInt(ld.getItemvalue());
                continue;
            }
            if (ld.getItemno().equals("Extyeepay")) {
                extyeepayrate = Integer.parseInt(ld.getItemvalue());
                continue;
            }
            if (!ld.getItemno().equals("Extalipay")) continue;
            extalipayrate = Integer.parseInt(ld.getItemvalue());
        }
        VelocityContext context = new VelocityContext();
        context.put("ext99billrate", (Object)ext99billrate);
        context.put("extyeepayrate", (Object)extyeepayrate);
        context.put("extalipayrate", (Object)extalipayrate);
        try {
            Utility.velocityPay2File(context, ApplicationConfigUtil.getStaticPagePay2Path(), "pay_bank.vm", "pay_bank.html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void generatePlacardsContentPages() throws Exception {
        List<Placards> list = this.getPlacardsByCardType(-1, "02", "('001')");
        VelocityContext context = new VelocityContext();
        for (Placards newsPlacard : list) {
            if (newsPlacard.getTitle().length() > 40) {
                newsPlacard.setTitle(String.valueOf(newsPlacard.getTitle().substring(0, 38)) + "...");
            } else {
                newsPlacard.setTitle(newsPlacard.getTitle());
            }
            context.put("newsPlacard", (Object)newsPlacard);
            try {
                Utility.velocityPay2File(context, ApplicationConfigUtil.getStaticPagePay2Path(), "placardscontent.vm", "placards" + File.separator + "placards" + newsPlacard.getCardid() + ".html");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        context = new VelocityContext();
        List<Placards> list1 = this.getPlacardsByCardType(-1, "02", "('003')");
        for (Placards questionPlacard : list1) {
            if (questionPlacard.getTitle().length() > 40) {
                questionPlacard.setTitle(String.valueOf(questionPlacard.getTitle().substring(0, 38)) + "...");
            } else {
                questionPlacard.setTitle(questionPlacard.getTitle());
            }
            context.put("newsPlacard", (Object)questionPlacard);
            try {
                Utility.velocityPay2File(context, ApplicationConfigUtil.getStaticPagePay2Path(), "helpcontent.vm", "help" + File.separator + "help" + questionPlacard.getCardid() + ".html");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void generatePlacardsPages() throws Exception {
        Placards placards = new Placards();
        placards.setInuse((short)1);
        placards.setCardtype("001");
        placards.setFlatno("00");
        List list = (List)IFacade.INSTANCE.queryPlacards(placards, null, 10).getDatas();
        VelocityContext context = new VelocityContext();
        context.put("placardslist", (Object)list);
        Utility.velocityFile(context, ApplicationConfigUtil.getPlacardsPath(), "placards.vm", "placards.htm");
    }

    @Override
    public void generateActivitiesPages() throws Exception {
        Placards placards = new Placards();
        placards.setInuse((short)1);
        placards.setCardtype("002");
        placards.setFlatno("00");
        List list2 = (List)IFacade.INSTANCE.queryPlacards(placards, null, 10).getDatas();
        VelocityContext context = new VelocityContext();
        context.put("activitylist", (Object)list2);
        Utility.velocityFile(context, ApplicationConfigUtil.getPlacardsPath(), "activities.vm", "activities.htm");
    }

    @Override
    public void generateIndexPages() throws Exception {
        Placards placards = new Placards();
        placards.setInuse((short)1);
        placards.setCardtype("001");
        placards.setFlatno("00");
        List list = (List)IFacade.INSTANCE.queryPlacards(placards, null, 5).getDatas();
        placards.setCardtype("002");
        List list2 = (List)IFacade.INSTANCE.queryPlacards(placards, null, 5).getDatas();
        VelocityContext context = new VelocityContext();
        context.put("placardslist", (Object)list);
        context.put("activitylist", (Object)list2);
        Utility.velocityFile(context, ApplicationConfigUtil.getIndexPath(), "index.vm", "index.htm");
    }
}

