/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.bo;

import com.xunlei.card.bo.BaseBo;
import com.xunlei.card.bo.ICopcashtransBo;
import com.xunlei.card.dao.ICopcashtransDao;
import com.xunlei.card.facade.IFacade;
import com.xunlei.card.util.Arith;
import com.xunlei.card.util.Utility;
import com.xunlei.card.util.XLCardRuntimeException;
import com.xunlei.card.vo.Copartners;
import com.xunlei.card.vo.Copbizchannel;
import com.xunlei.card.vo.Copcashmessage;
import com.xunlei.card.vo.Copcashtrans;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.LibClassM;
import org.apache.log4j.Logger;

public class CopcashtransBoImpl
extends BaseBo
implements ICopcashtransBo {
    private static Logger logger = Logger.getLogger(CopcashtransBoImpl.class);
    private ICopcashtransDao copcashtransDao;

    @Override
    public void deleteCopcashtransById(long ... seqids) {
        this.getCopcashtransDao().deleteCopcashtransById(seqids);
    }

    @Override
    public void deleteCopcashtrans(Copcashtrans data) {
        this.getCopcashtransDao().deleteCopcashtrans(data);
    }

    @Override
    public Copcashtrans findCopcashtrans(Copcashtrans data) {
        return this.getCopcashtransDao().findCopcashtrans(data);
    }

    @Override
    public Copcashtrans getCopcashtransById(long seqid) {
        return this.getCopcashtransDao().getCopcashtransById(seqid);
    }

    @Override
    public void insertCopcashtrans(Copcashtrans data) {
        this.getCopcashtransDao().insertCopcashtrans(data);
    }

    @Override
    public Sheet<Copcashtrans> queryCopcashtrans(Copcashtrans data, PagedFliper fliper) {
        return this.getCopcashtransDao().queryCopcashtrans(data, fliper);
    }

    @Override
    public void updateCopcashtrans(Copcashtrans data) {
        this.getCopcashtransDao().updateCopcashtrans(data);
    }

    public ICopcashtransDao getCopcashtransDao() {
        return this.copcashtransDao;
    }

    public void setCopcashtransDao(ICopcashtransDao copcashtransDao) {
        this.copcashtransDao = copcashtransDao;
    }

    @Override
    public double queryFinancetat(Copcashtrans data) {
        return this.getCopcashtransDao().queryFinancetat(data);
    }

    @Override
    public Copcashmessage doCopcashconsume(Copcashtrans data) {
        logger.debug((Object)"doCopcashconsume 001");
        String code = "00";
        Copcashmessage rtn = new Copcashmessage();
        try {
            Copbizchannel copbizchn = new Copbizchannel();
            copbizchn.setCopartnerid(data.getCopartnerid());
            copbizchn.setBizchanneltype(data.getBizchanneltype());
            Copbizchannel copbizchn2 = IFacade.INSTANCE.findCopbizchannel(copbizchn);
            if (copbizchn2 == null) {
                code = "01";
                throw new XLCardRuntimeException("\u4ee3\u7406\u5546[" + copbizchn.getCopartnerid() + "]\u65e0\u6e20\u9053\u4fe1\u606f[" + copbizchn.getBizchanneltype() + "]");
            }
            logger.debug((Object)"doCopcashconsume 002");
            if (copbizchn2.getBizchannelstatus().equals("F")) {
                code = "02";
                throw new XLCardRuntimeException("\u4ee3\u7406\u5546[" + copbizchn.getCopartnerid() + "]\u6e20\u9053[" + copbizchn.getBizchanneltype() + "]\u88ab\u51bb\u7ed3");
            }
            Copartners cop = new Copartners();
            cop.setCopartnerid(data.getCopartnerid());
            Copartners cop2 = IFacade.INSTANCE.findCopartners(cop);
            logger.debug((Object)"doCopcashconsume 003");
            double allcopamt = Arith.add(cop2.getCopcashamt(), copbizchn2.getCashamt());
            allcopamt = Arith.add(allcopamt, copbizchn2.getBackbenefitamt());
            allcopamt = Arith.add(allcopamt, copbizchn2.getUsecreditamt());
            logger.debug((Object)("doCopcashconsume 004 allcopamt=" + allcopamt));
            if (Arith.sub(allcopamt, data.getTransamt()) < 0.0) {
                code = "03";
                throw new XLCardRuntimeException("\u8d2d\u4e70\u91d1\u989d(" + data.getTransamt() + ")\u5927\u4e8e\u5b58\u91cf\u91d1\u989d(" + allcopamt + ")");
            }
            if (Arith.sub(copbizchn2.getFrozeamt(), data.getTransamt()) < 0.0) {
                code = "04";
                throw new XLCardRuntimeException("\u8d2d\u4e70\u91d1\u989d(" + data.getTransamt() + ")\u5927\u4e8e\u6e20\u9053\u51bb\u7ed3\u91d1\u989d(" + copbizchn2.getFrozeamt() + ")");
            }
            logger.debug((Object)"doCopcashconsume 005");
            double amtbackbenefit = 0.0;
            double amtchannelcash = 0.0;
            double amtcopcash = 0.0;
            double amtcredit = 0.0;
            double amtleave = data.getTransamt();
            if (amtleave > 0.0 && copbizchn2.getBackbenefitamt() > 0.0) {
                if (Arith.sub(copbizchn2.getBackbenefitamt(), amtleave) >= 0.0) {
                    amtbackbenefit = amtleave;
                    amtleave = 0.0;
                } else {
                    amtbackbenefit = copbizchn2.getBackbenefitamt();
                    amtleave = Arith.sub(amtleave, amtbackbenefit);
                }
                logger.debug((Object)("doCopcashconsume 006 amtbackbenefit=" + amtbackbenefit + ", amtleave=" + amtleave));
            }
            if (amtleave > 0.0 && copbizchn2.getCashamt() > 0.0) {
                if (Arith.sub(copbizchn2.getCashamt(), amtleave) >= 0.0) {
                    amtchannelcash = amtleave;
                    amtleave = 0.0;
                } else {
                    amtchannelcash = copbizchn2.getCashamt();
                    amtleave = Arith.sub(amtleave, amtchannelcash);
                }
                logger.debug((Object)("doCopcashconsume 006 amtchannelcash=" + amtchannelcash + ", amtleave=" + amtleave));
            }
            if (amtleave > 0.0 && cop2.getCopcashamt() > 0.0) {
                if (Arith.sub(cop2.getCopcashamt(), amtleave) >= 0.0) {
                    amtcopcash = amtleave;
                    amtleave = 0.0;
                } else {
                    amtcopcash = cop2.getCopcashamt();
                    amtleave = Arith.sub(amtleave, amtcopcash);
                }
                logger.debug((Object)("doCopcashconsume 006 amtcopcash=" + amtcopcash + ", amtleave=" + amtleave));
            }
            double canuse = copbizchn2.getUsecreditamt();
            if (amtleave > 0.0 && canuse > 0.0) {
                if (Arith.sub(canuse, amtleave) >= 0.0) {
                    amtcredit = amtleave;
                    amtleave = 0.0;
                } else {
                    amtcredit = canuse;
                    amtleave = Arith.sub(amtleave, amtcredit);
                }
                logger.debug((Object)("doCopcashconsume 006 amtcredit=" + amtcredit + ", amtleave=" + amtleave));
            }
            if (amtleave > 0.0) {
                code = "05";
                throw new XLCardRuntimeException("\u5b58\u91cf\u91d1\u989d\u4e0d\u8db32");
            }
            if (amtcopcash > 0.0) {
                Copcashtrans trans1 = new Copcashtrans();
                trans1.setCopartnerid(data.getCopartnerid());
                trans1.setBizchanneltype("99");
                trans1.setBcaccounttype("A");
                trans1.setTransamt(Arith.sub(0.0, amtcopcash));
                trans1.setTransbalance(Arith.sub(cop2.getCopcashamt(), amtcopcash));
                trans1.setCopcashtranstype("01");
                trans1.setApplynotecd(data.getApplynotecd());
                trans1.setChannelno("0000");
                trans1.setTradesn(Utility.getTradeSn());
                trans1.setBalancedate(Utility.dateofnow());
                trans1.setApplyby(data.getApplyby());
                trans1.setApplytime(data.getApplytime());
                trans1.setEdittime(CopcashtransBoImpl.now());
                trans1.setRemark("\u603b\u73b0\u91d1\u4e0b\u5212\u6e20\u9053\u73b0\u91d1 " + LibClassM.getLibClassDVo((String)"BizChannelType", (String)data.getBizchanneltype()).getItemname());
                Copcashtrans trans2 = new Copcashtrans();
                trans2.setCopartnerid(data.getCopartnerid());
                trans2.setBizchanneltype(data.getBizchanneltype());
                trans2.setBcaccounttype("B");
                trans2.setTransamt(amtcopcash);
                trans2.setTransbalance(Arith.add(copbizchn2.getCashamt(), amtcopcash));
                trans2.setCopcashtranstype("01");
                trans2.setApplynotecd(data.getApplynotecd());
                trans2.setChannelno("0000");
                trans2.setTradesn(Utility.getTradeSn());
                trans2.setBalancedate(Utility.dateofnow());
                trans2.setApplyby(data.getApplyby());
                trans2.setApplytime(data.getApplytime());
                trans2.setEdittime(CopcashtransBoImpl.now());
                trans2.setRemark("\u603b\u73b0\u91d1\u4e0b\u5212\u6e20\u9053\u73b0\u91d1");
                cop2.setCopcashamt(Arith.sub(cop2.getCopcashamt(), amtcopcash));
                copbizchn2.setCashamt(Arith.add(copbizchn2.getCashamt(), amtcopcash));
                logger.debug((Object)"doCopcashconsume 007");
                IFacade.INSTANCE.insertCopcashtrans(trans1);
                logger.debug((Object)"doCopcashconsume 007-1");
                IFacade.INSTANCE.insertCopcashtrans(trans2);
                logger.debug((Object)"doCopcashconsume 007-2");
                IFacade.INSTANCE.updateCopartners(cop2);
                logger.debug((Object)"doCopcashconsume 007-3");
            }
            int i = 0;
            while (i < 3) {
                logger.debug((Object)("doCopcashconsume 008 i=" + i));
                double tmpamt = 0.0;
                double tmpbalance = 0.0;
                double tmptransamt = 0.0;
                String bcaccounttype = "";
                String copcashtranstype = "";
                String remark = "";
                if (i == 0 && amtbackbenefit > 0.0) {
                    tmpamt = amtbackbenefit;
                    tmpbalance = Arith.sub(copbizchn2.getBackbenefitamt(), tmpamt);
                    bcaccounttype = "D";
                    copcashtranstype = "05";
                    remark = "\u6e20\u9053\u8fd4\u5229\u6d88\u8d39";
                    copbizchn2.setBackbenefitamt(tmpbalance);
                    tmptransamt = Arith.sub(0.0, tmpamt);
                } else if (i == 1 && Arith.add(amtchannelcash, amtcopcash) > 0.0) {
                    tmpamt = Arith.add(amtchannelcash, amtcopcash);
                    tmpbalance = Arith.sub(copbizchn2.getCashamt(), tmpamt);
                    bcaccounttype = "B";
                    copcashtranstype = "04";
                    remark = "\u6e20\u9053\u73b0\u91d1\u6d88\u8d39";
                    copbizchn2.setCashamt(tmpbalance);
                    tmptransamt = Arith.sub(0.0, tmpamt);
                } else if (i == 2 && amtcredit > 0.0) {
                    tmpamt = amtcredit;
                    tmpbalance = Arith.sub(copbizchn2.getUsecreditamt(), tmpamt);
                    bcaccounttype = "C";
                    copcashtranstype = "06";
                    remark = "\u6e20\u9053\u4fe1\u7528\u6d88\u8d39";
                    copbizchn2.setUsecreditamt(tmpbalance);
                    tmptransamt = Arith.sub(0.0, tmpamt);
                }
                if (tmpamt > 0.0) {
                    logger.debug((Object)"doCopcashconsume 008-1");
                    Copcashtrans tmptrans = new Copcashtrans();
                    tmptrans.setCopartnerid(data.getCopartnerid());
                    tmptrans.setBizchanneltype(data.getBizchanneltype());
                    tmptrans.setBcaccounttype(bcaccounttype);
                    tmptrans.setTransamt(tmptransamt);
                    tmptrans.setTransbalance(tmpbalance);
                    tmptrans.setCopcashtranstype(copcashtranstype);
                    tmptrans.setApplynotecd(data.getApplynotecd());
                    tmptrans.setChannelno("0000");
                    tmptrans.setTradesn(Utility.getTradeSn());
                    tmptrans.setBalancedate(Utility.dateofnow());
                    tmptrans.setApplyby(data.getApplyby());
                    tmptrans.setApplytime(data.getApplytime());
                    tmptrans.setEdittime(CopcashtransBoImpl.now());
                    tmptrans.setRemark(remark);
                    IFacade.INSTANCE.insertCopcashtrans(tmptrans);
                    logger.debug((Object)"doCopcashconsume 008-2");
                }
                ++i;
            }
            int bizchannelbal = 0;
            bizchannelbal = copbizchn2.getBizchannelbal() + data.getTransvalue();
            copbizchn2.setBizchannelbal(copbizchn2.getBizchannelbal() + data.getTransvalue());
            copbizchn2.setFrozeamt(Arith.sub(copbizchn2.getFrozeamt(), data.getTransamt()));
            IFacade.INSTANCE.updateCopbizchannel(copbizchn2);
            logger.debug((Object)"doCopcashconsume 009");
            rtn.setCode("00");
            rtn.setBackbenefitamt(amtbackbenefit);
            rtn.setCashamt(Arith.add(amtchannelcash, amtcopcash));
            rtn.setCreditamt(amtcredit);
            rtn.setBizchannelbal(bizchannelbal);
            return rtn;
        }
        catch (XLCardRuntimeException e) {
            logger.error((Object)("doCopcashconsume code=" + code));
        }
        catch (Exception e) {
            code = "99";
            logger.error((Object)("doCopcashconsume " + e));
        }
        rtn.setCode(code);
        return rtn;
    }
}

