/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.bo;

import com.xunlei.card.bo.BaseBo;
import com.xunlei.card.bo.ICardsBo;
import com.xunlei.card.dao.ICardsDao;
import com.xunlei.card.facade.IFacade;
import com.xunlei.card.util.Arith;
import com.xunlei.card.util.Utility;
import com.xunlei.card.util.XLCardRuntimeException;
import com.xunlei.card.vo.Cards;
import com.xunlei.card.vo.Copcardapply;
import com.xunlei.card.vo.Makecard;
import com.xunlei.card.vo.Parvaluetype;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import java.util.List;
import org.apache.log4j.Logger;

public class CardsBoImpl
extends BaseBo
implements ICardsBo {
    private static Logger logger = Logger.getLogger(CardsBoImpl.class);
    private ICardsDao cardsDao;

    public ICardsDao getCardsDao() {
        return this.cardsDao;
    }

    public void setCardsDao(ICardsDao cardsDao) {
        this.cardsDao = cardsDao;
    }

    @Override
    public void insertCards(Cards data) throws XLCardRuntimeException {
        this.getCardsDao().insertCards(data);
    }

    @Override
    public void updateCards(Cards data) throws XLCardRuntimeException {
        this.getCardsDao().updateCards(data);
    }

    @Override
    public void deleteCards(long ... id) throws XLCardRuntimeException {
        this.getCardsDao().deleteCards(id);
    }

    @Override
    public Cards findCards(long id) {
        return this.getCardsDao().findCards(id);
    }

    @Override
    public Sheet<Cards> queryCards(Cards idata, PagedFliper fliper) {
        return this.getCardsDao().queryCards(idata, fliper);
    }

    public String makeCardNo(String batchNo, String parNo, String cardNum) throws XLCardRuntimeException {
        logger.debug((Object)("makeCardNo begin batchNo=" + batchNo + ", parNo=" + parNo + ", cardNum=" + cardNum));
        if (batchNo.length() != 8) {
            throw new XLCardRuntimeException("\u6279\u6b21\u53f7\u957f\u5ea6\u4e0d\u7b26");
        }
        if (parNo.length() != 3) {
            throw new XLCardRuntimeException("\u9762\u503c\u7f16\u53f7\u957f\u5ea6\u4e0d\u7b26");
        }
        if (cardNum.length() != 4) {
            throw new XLCardRuntimeException("\u5361\u6d41\u6c34\u53f7\u957f\u5ea6\u4e0d\u7b26");
        }
        String cardNo = String.valueOf(batchNo) + parNo + cardNum;
        cardNo = String.valueOf(cardNo) + this.makeCardVerify(cardNo);
        logger.debug((Object)"makeCardNo end");
        return cardNo;
    }

    public String makeCardVerify(String cardNo) throws XLCardRuntimeException {
        logger.debug((Object)"makeCardVerify begin");
        if (cardNo.length() != 15) {
            throw new XLCardRuntimeException("\u8981\u6c42\u751f\u6210\u6821\u9a8c\u4f4d\u7684\u5361\u53f7\u957f\u5ea6\u4e0d\u7b26");
        }
        char[] cs = cardNo.toCharArray();
        int k = 0;
        int i = 0;
        while (i < cs.length) {
            k += cs[i] - 48;
            ++i;
        }
        int m = k % 10;
        logger.debug((Object)"makeCardVerify end");
        return "" + m;
    }

    public String makeCardPwd(String batchNo, String cardNum) throws XLCardRuntimeException {
        logger.debug((Object)"makeCardPwd begin");
        if (batchNo.length() != 8) {
            throw new XLCardRuntimeException("\u6279\u6b21\u53f7\u957f\u5ea6\u4e0d\u7b26");
        }
        if (cardNum.length() != 4) {
            throw new XLCardRuntimeException("\u5361\u6d41\u6c34\u53f7\u957f\u5ea6\u4e0d\u7b26");
        }
        String random8 = Utility.createSerial("" + Utility.createRandomNum(99999999), 8);
        String random5 = Utility.createSerial("" + Utility.createRandomNum(99999), 5);
        String random3 = Utility.createSerial("" + Utility.createRandomNum(999), 3);
        String cardPwd = String.valueOf(random8) + random5 + random3;
        logger.debug((Object)"makeCardPwd end");
        return cardPwd;
    }

    @Override
    public void makecardBatch(Makecard makecardData, Copcardapply copcardapply) {
        logger.debug((Object)"makecardBatch begin");
        List parList = IFacade.INSTANCE.getParvaluetypeByParNo(makecardData.getParno());
        if (parList.size() > 0) {
            Parvaluetype parvaluetype = (Parvaluetype)parList.get(0);
            int i = 0;
            while (i < makecardData.getCardqty()) {
                logger.debug((Object)("makecardBatch begin----------- i = " + i));
                int iCardNum = Integer.parseInt(makecardData.getFromnum()) + i;
                logger.debug((Object)("makecardBatch begin----------- iCardNum = " + iCardNum));
                String cardNum = Utility.createSerial("" + iCardNum, 4);
                logger.debug((Object)("makecardBatch begin----------- cardNum = " + cardNum));
                String cardNo = this.makeCardNo(makecardData.getBatchno(), makecardData.getParno(), cardNum);
                logger.debug((Object)("makecardBatch begin----------- cardNo = " + cardNo));
                String cardPwd = this.makeCardPwd(makecardData.getBatchno(), cardNum);
                double cardamt = Arith.mul(parvaluetype.getParvalue(), copcardapply.getBuyrebaterate());
                Cards data = new Cards();
                data.setCopartnerid(makecardData.getCopartnerid());
                data.setCardtypeno(makecardData.getCardtypeno());
                data.setMakeid(makecardData.getMakeid());
                data.setBatchno(makecardData.getBatchno());
                data.setSerialnum(cardNum);
                data.setCardno(cardNo);
                data.setCardpwd(cardPwd);
                data.setParvalue(parvaluetype.getParvalue());
                data.setLargessvalue(makecardData.getLargessvalue());
                data.setValiddate(makecardData.getValiddate());
                data.setApplynotecd(copcardapply.getApplynotecd());
                data.setCardamt(cardamt);
                data.setBuyrebaterate(copcardapply.getBuyrebaterate());
                IFacade.INSTANCE.insertCards(data);
                ++i;
            }
        } else {
            throw new XLCardRuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u9762\u503c");
        }
        logger.debug((Object)"makecardBatch end");
    }
}

