/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.eval;

import com.google.common.base.Strings;
import com.xunlei.channel.db.dao.RiskControlResultDAO;
import com.xunlei.channel.db.pojo.RiskControlResult;
import com.xunlei.channel.riskcontrol.alarm.service.AlarmService;
import com.xunlei.channel.riskcontrol.common.SerializeUtil;
import com.xunlei.channel.riskcontrol.constants.AlarmLevel;
import com.xunlei.channel.riskcontrol.constants.RiskResult;
import com.xunlei.channel.riskevaluator.constants.EvaluationCode;
import com.xunlei.channel.riskevaluator.context.EvalContext;
import com.xunlei.channel.riskevaluator.result.EvalResult;
import com.xunlei.channel.riskevaluator.service.EvaluatorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RiskControlEvaluator<T> {
    private static final Logger logger = LoggerFactory.getLogger(RiskControlEvaluator.class);
    @Autowired
    protected RiskControlResultDAO riskControlResultDAO;
    @Autowired
    protected EvaluatorService evaluatorService;
    @Autowired
    protected AlarmService alarmService;

    public void evalAndProcessEvalResult(EvalContext context, String taskName, T data) throws Exception {
        EvalResult result = this.evaluatorService.eval(context);
        logger.info("evalAndProcessEvalResult method:taskName {},context {},errorCode {},errorMsg{} ", new Object[]{taskName, context.getId(), result.getErrorCode(), result.getErrorMsg()});
        if (null != result) {
            if (!result.isEvalSucceess()) {
                this.processFailResult(result, context.getId(), context.getPayType(), taskName, data, AlarmLevel.RECHECK.getLevel());
            } else if (result.getErrorCode().equals(EvaluationCode.ERROR_01.getCode())) {
                this.processAlarmNowResult(result, context.getId(), context.getPayType(), taskName, data);
            } else if (result.isRuleSuccess()) {
                this.processSuccessResult(result, context.getId(), taskName, data);
            } else {
                this.processFailResult(result, context.getId(), context.getPayType(), taskName, data, AlarmLevel.RECHECK.getLevel());
            }
        }
    }

    private void processAlarmNowResult(EvalResult result, String contextId, String payType, String taskName, T data) throws Exception {
        logger.info("id:{} risk control  alarm now with result:{}", (Object)contextId, (Object)result);
        RiskControlResult riskControlResult = this.riskControlResultDAO.getRiskControlResult(contextId, taskName);
        String errorCode = result.getErrorCode();
        String errorMsg = result.getErrorMsg();
        if (Strings.isNullOrEmpty((String)errorMsg)) {
            errorMsg = EvaluationCode.ERROR_01.getMessage();
        }
        if (null == riskControlResult) {
            riskControlResult = new RiskControlResult();
            riskControlResult.setAlarmLevel(AlarmLevel.ALARM_NOW.getLevel());
            riskControlResult.setData(SerializeUtil.serialize(data));
            riskControlResult.setDataId(contextId);
            riskControlResult.setFailCount(1);
            riskControlResult.setErrorCode(errorCode);
            riskControlResult.setResultDesc(errorMsg);
            riskControlResult.setTaskName(taskName);
            riskControlResult.setResultValue(RiskResult.FAIL.getCode());
            riskControlResult.setPayType(payType);
            this.riskControlResultDAO.saveRiskControlResult(riskControlResult);
        } else {
            int failCount = riskControlResult.getFailCount() + 1;
            riskControlResult.setFailCount(failCount);
            riskControlResult.setAlarmLevel(AlarmLevel.ALARM_NOW.getLevel());
            riskControlResult.setResultValue(RiskResult.FAIL.getCode());
            riskControlResult.setResultDesc(riskControlResult.getResultDesc() + ";" + errorMsg);
            riskControlResult.setErrorCode(errorCode);
            this.riskControlResultDAO.updateRiskControlResult(riskControlResult);
        }
    }

    private void processFailResult(EvalResult result, String contextId, String payType, String taskName, T data, String alarmLevel) throws Exception {
        logger.info("id:{} risk control  failed with result:{}", (Object)contextId, (Object)result);
        RiskControlResult riskControlResult = this.riskControlResultDAO.getRiskControlResult(contextId, taskName);
        String errorCode = result.getErrorCode();
        String errorMsg = result.getErrorMsg();
        if (Strings.isNullOrEmpty((String)errorMsg)) {
            errorMsg = EvaluationCode.ERROR_04.getMessage();
        }
        if (null == riskControlResult) {
            riskControlResult = new RiskControlResult();
            riskControlResult.setAlarmLevel(alarmLevel);
            riskControlResult.setData(SerializeUtil.serialize(data));
            riskControlResult.setDataId(contextId);
            riskControlResult.setFailCount(1);
            riskControlResult.setErrorCode(errorCode);
            riskControlResult.setResultDesc(errorMsg);
            riskControlResult.setTaskName(taskName);
            riskControlResult.setResultValue(RiskResult.FAIL.getCode());
            riskControlResult.setPayType(payType);
            this.riskControlResultDAO.saveRiskControlResult(riskControlResult);
        } else {
            int failCount = riskControlResult.getFailCount() + 1;
            riskControlResult.setFailCount(failCount);
            riskControlResult.setAlarmLevel(failCount >= 5 ? AlarmLevel.ALARM_NOW.getLevel() : alarmLevel);
            riskControlResult.setResultValue(RiskResult.FAIL.getCode());
            riskControlResult.setResultDesc(Strings.isNullOrEmpty((String)riskControlResult.getResultDesc()) ? errorMsg : riskControlResult.getResultDesc() + ";" + errorMsg);
            riskControlResult.setErrorCode(errorCode);
            this.riskControlResultDAO.updateRiskControlResult(riskControlResult);
        }
    }

    private void processSuccessResult(EvalResult result, String contextId, String taskName, T data) throws Exception {
        RiskControlResult riskControlResult;
        logger.info("id:{} risk control successed", (Object)contextId);
        String msg = result.getErrorMsg();
        if (Strings.isNullOrEmpty((String)msg)) {
            msg = EvaluationCode.SUCCESS_00.getMessage();
        }
        if (null != (riskControlResult = this.riskControlResultDAO.getRiskControlResult(contextId, taskName))) {
            riskControlResult.setAlarmLevel(AlarmLevel.RECHECK_SUCCESS.getLevel());
            riskControlResult.setResultValue(RiskResult.SUCCESS.getCode());
            riskControlResult.setErrorCode(null);
            riskControlResult.setResultDesc(Strings.isNullOrEmpty((String)riskControlResult.getResultDesc()) ? msg : riskControlResult.getResultDesc() + ";" + msg);
            this.riskControlResultDAO.updateRiskControlResult(riskControlResult);
        }
    }
}

