/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.alarm.processor;

import com.xunlei.channel.db.dao.RiskControlResultDAO;
import com.xunlei.channel.db.pojo.RiskControlResult;
import com.xunlei.channel.riskcontrol.alarm.vo.AlarmStatusVo;
import com.xunlei.channel.riskcontrol.constants.AlarmLevel;
import com.xunlei.channel.riskcontrol.constants.RiskResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MessageProcessor.class);
    @Autowired
    private RiskControlResultDAO riskControlResultDAO;
    private int checkFailTimes;
    private boolean lastCheckFailed;

    public AlarmStatusVo isAlarm() {
        List results = this.riskControlResultDAO.getRiskControlResultByValueAndAlarmLevel(RiskResult.FAIL.getCode(), new String[]{AlarmLevel.ALARM_NOW.getLevel()}, 500);
        return this.checkFailTimes(results);
    }

    public boolean isSuccess(Collection<RiskControlResult> results) {
        return results.isEmpty();
    }

    protected Map<String, Integer> processDetail(Collection<RiskControlResult> results) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (RiskControlResult allValue : results) {
            String resultDesc = allValue.getResultDesc();
            if (resultDesc == null) continue;
            Integer integer = (Integer)map.get(resultDesc);
            if (integer == null || integer == 0) {
                map.put(resultDesc, 1);
                continue;
            }
            map.put(resultDesc, integer + 1);
        }
        if (logger.isInfoEnabled()) {
            logger.info("processDetail... all values: {}, result: {}", results, map);
        }
        return map;
    }

    public AlarmStatusVo checkFailTimes(Collection<RiskControlResult> results) {
        boolean success = this.isSuccess(results);
        if (this.lastCheckFailed) {
            if (success) {
                this.checkFailTimes = 0;
                this.lastCheckFailed = false;
            } else {
                ++this.checkFailTimes;
                this.lastCheckFailed = true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("isNeedAlarm... checkFailTimes: {}, isSuccess: {}, return: true", (Object)this.checkFailTimes, (Object)this.isSuccess(results));
            }
            return new AlarmStatusVo(true, success, this.checkFailTimes, results.size(), this.processDetail(results));
        }
        if (success) {
            this.checkFailTimes = 0;
            this.lastCheckFailed = false;
            if (logger.isDebugEnabled()) {
                logger.debug("isNeedAlarm... lastCheckFailed: {}, isSuccess: {}, return: false", (Object)this.lastCheckFailed, (Object)this.isSuccess(results));
            }
            return new AlarmStatusVo(false, success, this.checkFailTimes, results.size(), this.processDetail(results));
        }
        ++this.checkFailTimes;
        this.lastCheckFailed = true;
        logger.info("isNeedAlarm... lastCheckFailed: {}, isSuccess: {}, return: true", (Object)this.lastCheckFailed, (Object)this.isSuccess(results));
        return new AlarmStatusVo(true, success, this.checkFailTimes, results.size(), this.processDetail(results));
    }

    public int getCheckFailTimes() {
        return this.checkFailTimes;
    }

    public void setCheckFailTimes(int checkFailTimes) {
        this.checkFailTimes = checkFailTimes;
    }
}

