/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.data.provider.impl;

import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.paycommon.util.time.DateUtil;
import com.xunlei.channel.riskcontrol.common.ConfigInfoUtils;
import com.xunlei.channel.riskcontrol.constants.SourceDataProviderId;
import com.xunlei.channel.riskcontrol.data.provider.AbstractSourceDataProvider;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderSourceDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(OrderSourceDataProvider.class);
    @Autowired
    PayOrderDAO payOrderDAO;
    @Autowired
    ConfigInfoUtils configInfoUtils;

    public OrderSourceDataProvider() {
        new AbstractSourceDataProvider<PayOrder>(){
            private ThreadLocal<Long> updateId = new ThreadLocal<Long>(){

                @Override
                protected Long initialValue() {
                    return -1L;
                }
            };

            @Override
            public List<PayOrder> loadData(Map<String, Object> params) throws Exception {
                String id = OrderSourceDataProvider.this.configInfoUtils.getConfigValue("risk_control", "pay_order_id_fail");
                if (id == null) {
                    logger.error("cant find config_info for group_id:{},cache_key:{}", (Object)"risk_control", (Object)"pay_order_id_fail");
                    throw new Exception("cant find config_info for key:pay_order_id_fail");
                }
                List list = OrderSourceDataProvider.this.payOrderDAO.getPayOrderByMinIdAndStatus(Long.parseLong(id), new String[]{"F"}, 100);
                if (list.size() > 0) {
                    long maxId = ((PayOrder)list.get(list.size() - 1)).getId();
                    logger.info("change maxId {}", (Object)maxId);
                    this.updateId.set(maxId);
                }
                return list;
            }

            @Override
            public String getId() {
                return SourceDataProviderId.PAY_ORDER_FAIL_BY_ID.getValue();
            }

            @Override
            public void updateData() throws Exception {
                if (this.updateId.get() > -1L) {
                    boolean result = OrderSourceDataProvider.this.configInfoUtils.updateConfigValue("risk_control", "pay_order_id_fail", String.valueOf(this.updateId.get()));
                    this.updateId.set(-1L);
                    if (!result) {
                        throw new Exception("updateData failed");
                    }
                }
            }
        };
        new AbstractSourceDataProvider<PayOrder>(){
            private ThreadLocal<Long> updateId = new ThreadLocal<Long>(){

                @Override
                protected Long initialValue() {
                    return -1L;
                }
            };

            @Override
            public List<PayOrder> loadData(Map<String, Object> params) throws Exception {
                String id = OrderSourceDataProvider.this.configInfoUtils.getConfigValue("risk_control", "pay_order_id_ok");
                if (id == null) {
                    logger.error("cant find config_info for group_id:{},cache_key:{}", (Object)"risk_control", (Object)"pay_order_id_ok");
                    throw new Exception("cant find config_info for key:pay_order_id_ok");
                }
                List list = OrderSourceDataProvider.this.payOrderDAO.getPayOrderByMinIdAndStatus(Long.parseLong(id), new String[]{"S"}, 100);
                if (list.size() > 0) {
                    long maxId = ((PayOrder)list.get(list.size() - 1)).getId();
                    logger.info("change maxId {}", (Object)maxId);
                    this.updateId.set(maxId);
                }
                return list;
            }

            @Override
            public String getId() {
                return SourceDataProviderId.PAY_ORDER_OK_BY_ID.getValue();
            }

            @Override
            public void updateData() throws Exception {
                if (this.updateId.get() > -1L) {
                    boolean result = OrderSourceDataProvider.this.configInfoUtils.updateConfigValue("risk_control", "pay_order_id_ok", String.valueOf(this.updateId.get()));
                    this.updateId.set(-1L);
                    if (!result) {
                        throw new Exception("updateData failed");
                    }
                }
            }
        };
        new AbstractSourceDataProvider<PayOrder>(){
            private ThreadLocal<Long> updateId = new ThreadLocal<Long>(){

                @Override
                protected Long initialValue() {
                    return -1L;
                }
            };

            @Override
            public List<PayOrder> loadData(Map<String, Object> params) throws Exception {
                String fromTimePeriod = null;
                String toTimePeriod = null;
                try {
                    fromTimePeriod = params.get("from_time_period").toString();
                    toTimePeriod = params.get("to_time_period").toString();
                }
                catch (Exception e) {
                    logger.error("cant find from_time_period or to_time_period in task params:", (Throwable)e);
                    throw new Exception("cant find from_time_period or to_time_period in task params");
                }
                String id = OrderSourceDataProvider.this.configInfoUtils.getConfigValue("risk_control", "pay_order_id_wait");
                if (id == null) {
                    logger.error("cant find config_info for group_id:{},cache_key:{}", (Object)"risk_control", (Object)"pay_order_id_wait");
                    throw new Exception("cant find config_info for key:pay_order_id_wait");
                }
                String nowTime = DateUtil.getCurrentTime((String)"yyyy-MM-dd HH:mm:ss");
                String fromTime = DateUtil.calculateTime((String)nowTime, (String)"yyyy-MM-dd HH:mm:ss", (String)"F", (int)Integer.parseInt(fromTimePeriod));
                String toTime = DateUtil.calculateTime((String)nowTime, (String)"yyyy-MM-dd HH:mm:ss", (String)"F", (int)Integer.parseInt(toTimePeriod));
                List list = OrderSourceDataProvider.this.payOrderDAO.getPayOrderByCreateTime(fromTime, toTime, new String[]{"W"}, Long.parseLong(id), 100);
                if (list.size() > 0) {
                    long maxId = ((PayOrder)list.get(list.size() - 1)).getId();
                    logger.info("change maxId {}", (Object)maxId);
                    this.updateId.set(maxId);
                }
                return list;
            }

            @Override
            public String getId() {
                return SourceDataProviderId.PAY_ORDER_WAIT_BY_CREATETIME.getValue();
            }

            @Override
            public void updateData() throws Exception {
                if (this.updateId.get() > -1L) {
                    boolean result = OrderSourceDataProvider.this.configInfoUtils.updateConfigValue("risk_control", "pay_order_id_wait", String.valueOf(this.updateId.get()));
                    this.updateId.set(-1L);
                    if (!result) {
                        throw new Exception("updateData failed");
                    }
                }
            }
        };
    }
}

