/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.axis.encoding.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeUtil {
    private static Logger logger = LoggerFactory.getLogger(SerializeUtil.class);
    public static final String CHARSET = "UTF-8";

    private SerializeUtil() {
    }

    public static String serialize(Object o) throws Exception {
        if (o == null) {
            throw new NullPointerException("Can't serialize null");
        }
        byte[] rv = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream os = null;
        try {
            bos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bos);
            os.writeObject(o);
            os.close();
            bos.close();
            rv = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Non-serializable object", e);
            }
            catch (Throwable throwable) {
                SerializeUtil.close(os);
                SerializeUtil.close(bos);
                throw throwable;
            }
        }
        SerializeUtil.close(os);
        SerializeUtil.close(bos);
        return Base64.encode((byte[])rv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(String objectStr) {
        ObjectInputStream is;
        ByteArrayInputStream bis;
        Object rv;
        block4: {
            rv = null;
            bis = null;
            is = null;
            try {
                byte[] in = Base64.decode((String)objectStr);
                if (in == null) break block4;
                bis = new ByteArrayInputStream(in);
                is = new ObjectInputStream(bis);
                rv = is.readObject();
                is.close();
                bis.close();
            }
            catch (Exception e) {
                try {
                    logger.error("", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SerializeUtil.close(is);
                    SerializeUtil.close(bis);
                    throw throwable;
                }
                SerializeUtil.close(is);
                SerializeUtil.close(bis);
            }
        }
        SerializeUtil.close(is);
        SerializeUtil.close(bis);
        return rv;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                logger.error("Unable to close " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

