/**
 * Project: xl-risk-control
 * <p/>
 * File Created at 2015年3月20日
 * lizhaog
 * <p/>
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * <p/>
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.riskcontrol.task.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.riskcontrol.constants.RiskResult;
import com.xunlei.channel.riskevaluator.constants.EvaluationCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xunlei.channel.db.common.Constants;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.dao.RiskControlResultDAO;
import com.xunlei.channel.db.dao.RiskControlTaskDAO;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.RiskControlResult;
import com.xunlei.channel.db.pojo.RiskControlTask;
import com.xunlei.channel.riskcontrol.common.SerializeUtil;
import com.xunlei.channel.riskcontrol.constants.AlarmLevel;
import com.xunlei.channel.riskcontrol.eval.RiskControlEvaluator;
import com.xunlei.channel.riskcontrol.task.AbstractRiskTask;
import com.xunlei.channel.riskevaluator.context.EvalContext;

/**
 * 重查任务
 *
 * @author lizhaog
 */
@Service
public class ReCheckTask {

    private static final Logger logger = LoggerFactory
            .getLogger(ReCheckTask.class);

    @Autowired
    RiskControlResultDAO riskControlResultDAO;

    @Autowired
    protected RiskControlTaskDAO riskControlTaskDAO;

    @Autowired
    protected PayOrderDAO payOrderDAO;

    @Autowired
    protected PayOrderOkDAO payOrderOkDAO;

    @Autowired
    protected RiskControlEvaluator<Serializable> riskControlEvaluator;

    public void recheck() throws Exception {
        // 1. 拉取风控失败的数据
        //SQL:select * from risk_control_result where result_value=? and alarm_level in ( ? ) order by id limit ?
        //params {result_value:N(失败);alarm_level:[1](等待重查);limit:100(100太少?)}
        List<RiskControlResult> datas = riskControlResultDAO
                .getRiskControlResultByValueAndAlarmLevel(RiskResult.FAIL.getCode(),
                        new String[]{AlarmLevel.RECHECK.getLevel(),AlarmLevel.ALARM_NOW.getLevel()}
                        , com.xunlei.channel.riskcontrol.constants.Constants.SOURCE_DATA_LIMIT_500);
        if (logger.isInfoEnabled()) {
            logger.info("recheck task find {} datas", datas.size());
        }
        // 2. 执行规则判断
        for (final RiskControlResult riskControlResult : datas) {
            // 首先查一下数据还在不在
            if (logger.isInfoEnabled()) {
                logger.info("riskControlResult:dataId {};taskName {};errorCode {};resultDesc {} ",riskControlResult.getDataId(),riskControlResult.getTaskName(),riskControlResult.getErrorCode(),riskControlResult.getResultDesc());
            }
            if ("ORDER_WAIT".equals(riskControlResult.getTaskName())
                    && EvaluationCode.ERROR_01.getCode().equals(riskControlResult.getErrorCode())) {
                // 如果是掉单
                PayOrder payOrder = payOrderDAO.getPayOrder(String.valueOf(riskControlResult
                        .getDataId()));
                if (payOrder != null && payOrder.getStatus().equals(Constants.ORDER_STATUS_SUCCESS)) {
                    // 如果已经成功
                    riskControlResult.setAlarmLevel(AlarmLevel.RECHECK_SUCCESS.getLevel());
                    riskControlResult.setResultValue(RiskResult.SUCCESS.getCode());
                    riskControlResult.setErrorCode(null);
                    riskControlResult.setResultDesc(riskControlResult.getResultDesc()+";订单已处理成功");
                    riskControlResultDAO.updateRiskControlResult(riskControlResult);
                }
                continue;
            }
            //判断成功订单成功通知给业务线，且查询成功
            else if ("ORDER_OK".equals(riskControlResult.getTaskName())
                    && EvaluationCode.ERROR_03.getCode().equals(riskControlResult.getErrorCode())) {
                // 如果是通知引擎为F,则再次查询状态，如果正确则更新风控状态
                PayOrderOk payOrderOk = payOrderOkDAO.getPayOrderOk(String.valueOf(riskControlResult
                        .getDataId()));
                if (payOrderOk != null && payOrderOk.getSendNoticeStatus().equals(Constants.PAY_NOTICE_STATUS_SUCCESS)) {
                    // 如果已经通知引擎成功,则再次放入重查阶段，则订单处理成功。
                    riskControlResult.setAlarmLevel(AlarmLevel.RECHECK_SUCCESS.getLevel());
                    riskControlResult.setResultValue(RiskResult.SUCCESS.getCode());
                    riskControlResult.setErrorCode(null);
                    riskControlResult.setResultDesc(riskControlResult.getResultDesc()+";通知引擎成功且订单已处理成功");
                    riskControlResultDAO.updateRiskControlResult(riskControlResult);
                }
                continue;
            }

            try {
                new AbstractRiskTask<Serializable>(riskControlTaskDAO, riskControlEvaluator) {

                    @Override
                    protected List<Serializable> loadData(RiskControlTask riskControlTask,
                                                          Map<String, Object> paramMap)
                            throws Exception {
                        //反序列化生成PayOrder类型对象
                        Serializable data = (Serializable) SerializeUtil
                                .deserialize(riskControlResult.getData());
                        List<Serializable> list = new ArrayList<Serializable>();
                        list.add(data);
                        return list;
                    }

                    @Override
                    protected EvalContext initialEvalContext(Serializable data,
                                                             Map<String, Object> paramMap,
                                                             String rule) throws Exception {
                        EvalContext context = new EvalContext();
                        context.setId(riskControlResult.getDataId());
                        context.setData(paramMap);
                        context.setRule(rule);
                        return context;
                    }
                }.execute(riskControlResult.getTaskName());
            } catch (Exception e) { // 将recheck过程的异常包装一下，不影响其他任务的执行
                logger.error("", e);
            }
        }
    }
}
