/**
 * Project: xl-risk-control
 * 
 * File Created at 2015年3月12日
 * lizhaog
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.riskcontrol.task.impl;

import java.util.Map;

import org.springframework.stereotype.Service;

import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.riskcontrol.task.AbstractSourceDataRiskTask;
import com.xunlei.channel.riskevaluator.context.EvalContext;

/**
 * 对元数据是PayOrder的风控任务可用，如根据时间去订单表获取订单数据进行风控
 * 
 * @author lizhaog
 */
@Service
public class PayOrderRiskTask extends AbstractSourceDataRiskTask<PayOrder> {

    @Override
    public EvalContext initialEvalContext(PayOrder data, Map<String, Object> paramMap, String rule) {
        EvalContext context = new EvalContext();
        context.setId(String.valueOf(data.getXunleiPayId()));
        context.setData(paramMap);
        context.setRule(rule);
        return context;
    }


}
