/**
 * Project: xl-risk-control
 * 
 * File Created at 2015年3月12日
 * lizhaog
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.riskcontrol.task;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.base.Strings;
import com.xunlei.channel.db.pojo.RiskControlTask;
import com.xunlei.channel.riskcontrol.data.provider.SourceDataProvider;
import com.xunlei.channel.riskcontrol.data.provider.SourceDataProviderFactory;

/**
 * 限制T的类型一定要实现序列化，目的在于用于查询失败时，风控重查可以直接拿序列化数据进行查询，因为风控重查任务已经没办法去找到元数据的位置了
 * 
 * @author lizhaog
 */
public abstract class AbstractSourceDataRiskTask<T extends Serializable> extends
        AbstractRiskTask<T> {

    private static final Logger logger = LoggerFactory.getLogger(AbstractSourceDataRiskTask.class);

    @Override
    protected List<T> loadData(RiskControlTask riskControlTask, Map<String, Object> paramMap)
            throws Exception {
        String dataProviderId = riskControlTask.getTaskDataProvider();
        String taskName = riskControlTask.getTaskName();
        if (Strings.isNullOrEmpty(dataProviderId)) {
            logger.error(
                    "taskName:{} execute failed,invalid taskinfo[dataProviderId is empty] config in db:risk_control_task",
                    taskName);
            throw new Exception(
                    "taskName:"
                            + taskName
                            + "execute failed,invalid taskinfo[dataProviderId is empty] config in db:risk_control_task");
        }

        // 2.拿数据
        @SuppressWarnings("unchecked")
        SourceDataProvider<T> dataProvider = (SourceDataProvider<T>) SourceDataProviderFactory
                .getRuleDataProvider(dataProviderId);
        if (dataProvider == null) {
            logger.error(
                    "taskName:{} execute failed,invalid taskinfo[dataProviderId:{}] config in db:risk_control_task",
                    taskName, dataProviderId);
            throw new Exception("taskName:" + taskName
                    + "execute failed,invalid taskinfo[dataProviderId:" + dataProviderId
                    + "] config in db:risk_control_task");
        }
        return dataProvider.loadData(paramMap);
    }

    @Override
    protected void afterEval(RiskControlTask riskControlTask) throws Exception {
        String dataProviderId = riskControlTask.getTaskDataProvider();
        @SuppressWarnings("unchecked")
        SourceDataProvider<T> dataProvider = (SourceDataProvider<T>) SourceDataProviderFactory
                .getRuleDataProvider(dataProviderId);
        dataProvider.updateData();

    }

}
