/**
 * Project: xl-risk-control
 * <p/>
 * File Created at 2015年3月12日
 * lizhaog
 * <p/>
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * <p/>
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.riskcontrol.data.provider.impl;

import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.paycommon.util.time.DateUtil;
import com.xunlei.channel.riskcontrol.common.ConfigInfoUtils;
import com.xunlei.channel.riskcontrol.constants.Constants;
import com.xunlei.channel.riskcontrol.constants.SourceDataProviderId;
import com.xunlei.channel.riskcontrol.data.provider.AbstractSourceDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author lizhaog
 */
@Component
public class OrderSourceDataProvider {

    private static final Logger logger = LoggerFactory.getLogger(OrderSourceDataProvider.class);

    @Autowired
    PayOrderDAO payOrderDAO;

    @Autowired
    ConfigInfoUtils configInfoUtils;

    {
        // 根据ID获取订单表中支付失败的订单
        new AbstractSourceDataProvider<PayOrder>() {
            private ThreadLocal<Long> updateId = new ThreadLocal<Long>() {
                @Override
                protected Long initialValue() {
                    return -1L;
                }
            };

            @Override
            public List<PayOrder> loadData(Map<String, Object> params) throws Exception {
                // 首先获取id值
                String id = configInfoUtils.getConfigValue(Constants.CONFIG_GROUP_ID,
                        Constants.CONFIG_PAY_ORDER_ID_FAIL);
                if (id == null) {
                    logger.error("cant find config_info for group_id:{},cache_key:{}",
                            Constants.CONFIG_GROUP_ID, Constants.CONFIG_PAY_ORDER_ID_FAIL);
                    throw new Exception("cant find config_info for key:"
                            + Constants.CONFIG_PAY_ORDER_ID_FAIL);
                }
                List<PayOrder> list = payOrderDAO.getPayOrderByMinIdAndStatus(Long.parseLong(id),
                        new String[]{com.xunlei.channel.db.common.Constants.ORDER_STATUS_FAIL},
                        Constants.SOURCE_DATA_LIMIT_100);
                if (list.size() > 0) {
                    long maxId = list.get(list.size() - 1).getId();
                    updateId.set(maxId);
                }
                return list;
            }

            @Override
            public String getId() {
                return SourceDataProviderId.PAY_ORDER_FAIL_BY_ID.getValue();
            }

            @Override
            public void updateData() throws Exception {
                if (updateId.get() > -1) {
                    boolean result = configInfoUtils.updateConfigValue(Constants.CONFIG_GROUP_ID,
                            Constants.CONFIG_PAY_ORDER_ID_FAIL, String.valueOf(updateId.get()));
                    updateId.set(-1L);
                    if (result == false) {
                        throw new Exception("updateData failed");
                    }
                }
            }

        };
    }

    {
        // 根据ID获取订单表中支付成功的订单
        new AbstractSourceDataProvider<PayOrder>() {
            private ThreadLocal<Long> updateId = new ThreadLocal<Long>() {
                @Override
                protected Long initialValue() {
                    return -1L;
                }
            };

            @Override
            public List<PayOrder> loadData(Map<String, Object> params) throws Exception {
                // 首先获取id值
                String id = configInfoUtils.getConfigValue(Constants.CONFIG_GROUP_ID,
                        Constants.CONFIG_PAY_ORDER_ID_OK);
                if (id == null) {
                    logger.error("cant find config_info for group_id:{},cache_key:{}",
                            Constants.CONFIG_GROUP_ID, Constants.CONFIG_PAY_ORDER_ID_OK);
                    throw new Exception("cant find config_info for key:"
                            + Constants.CONFIG_PAY_ORDER_ID_OK);
                }
                List<PayOrder> list = payOrderDAO
                        .getPayOrderByMinIdAndStatus(
                                Long.parseLong(id),
                                new String[]{com.xunlei.channel.db.common.Constants.ORDER_STATUS_SUCCESS},
                                Constants.SOURCE_DATA_LIMIT_100);
                if (list.size() > 0) {
                    long maxId = list.get(list.size() - 1).getId();
                    updateId.set(maxId);
                }
                return list;
            }

            @Override
            public String getId() {
                return SourceDataProviderId.PAY_ORDER_OK_BY_ID.getValue();
            }

            @Override
            public void updateData() throws Exception {
                if (updateId.get() > -1) {
                    boolean result = configInfoUtils.updateConfigValue(Constants.CONFIG_GROUP_ID,
                            Constants.CONFIG_PAY_ORDER_ID_OK, String.valueOf(updateId.get()));
                    updateId.set(-1L);
                    if (result == false) {
                        throw new Exception("updateData failed");
                    }
                }
            }
        };
    }

    {
        // 根据时间获取订单表中待支付的订单
        new AbstractSourceDataProvider<PayOrder>() {

            private ThreadLocal<Long> updateId = new ThreadLocal<Long>() {
                @Override
                protected Long initialValue() {
                    return -1L;
                }
            };

            @Override
            public List<PayOrder> loadData(Map<String, Object> params) throws Exception {
                // 获取任务配置的时间条件
                String fromTimePeriod = null;
                String toTimePeriod = null;
                try {
                    fromTimePeriod = params.get("from_time_period").toString();
                    toTimePeriod = params.get("to_time_period").toString();
                } catch (Exception e) {
                    logger.error("cant find from_time_period or to_time_period in task params:", e);
                    throw new Exception(
                            "cant find from_time_period or to_time_period in task params");
                }

                // 获取读取订单时的id值
                String id = configInfoUtils.getConfigValue(Constants.CONFIG_GROUP_ID,
                        Constants.CONFIG_PAY_ORDER_ID_WAIT);
                if (id == null) {
                    logger.error("cant find config_info for group_id:{},cache_key:{}",
                            Constants.CONFIG_GROUP_ID, Constants.CONFIG_PAY_ORDER_ID_WAIT);
                    throw new Exception("cant find config_info for key:"
                            + Constants.CONFIG_PAY_ORDER_ID_WAIT);
                }
                String nowTime = DateUtil.getCurrentTime(DateUtil.SP1);
                String fromTime = DateUtil.calculateTime(nowTime, DateUtil.SP1, "F",
                        Integer.parseInt(fromTimePeriod));
                String toTime = DateUtil.calculateTime(nowTime, DateUtil.SP1, "F",
                        Integer.parseInt(toTimePeriod));
                //获取createTime在fromTime到toTime之间且大于id的订单信息
                List<PayOrder> list = payOrderDAO.getPayOrderByCreateTime(fromTime, toTime,
                        new String[]{com.xunlei.channel.db.common.Constants.ORDER_STATUS_WAIT},
                        Long.parseLong(id), Constants.SOURCE_DATA_LIMIT_100);
//                //更新最新ID的缓存数据
                if (list.size() > 0) {
                    long maxId = list.get(list.size() - 1).getId();
                    updateId.set(maxId);
                }
                return list;
            }

            @Override
            public String getId() {
                return SourceDataProviderId.PAY_ORDER_WAIT_BY_CREATETIME.getValue();
            }

            @Override
            public void updateData() throws Exception {
                if (updateId.get() > -1) {
                    boolean result = configInfoUtils.updateConfigValue(Constants.CONFIG_GROUP_ID,
                            Constants.CONFIG_PAY_ORDER_ID_WAIT, String.valueOf(updateId.get()));
                    updateId.set(-1L);
                    if (result == false) {
                        throw new Exception("updateData failed");
                    }
                }
            }

        };
    }
}
