/**
 * Project: xl-risk-control
 * 
 * File Created at 2015年3月12日
 * lizhaog
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.riskcontrol.data.provider;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author lizhaog
 */
public class SourceDataProviderFactory {
    private static Map<String, SourceDataProvider<?>> providers = new ConcurrentHashMap<String, SourceDataProvider<?>>();

    public static void register(String id, SourceDataProvider<?> provider) {
        providers.put(id, provider);
    }

    public static SourceDataProvider<?> getRuleDataProvider(String id) {
        return providers.get(id);
    }
}
