/**
 * Project: xl-risk-control
 * 
 * File Created at 2015年3月12日
 * lizhaog
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.riskcontrol.data.provider;

import java.util.List;
import java.util.Map;

/**
 * @author lizhaog
 */
public interface SourceDataProvider<T> {

    /**
     * 获取元数据
     * 
     * @param params
     * @return
     * @throws Exception
     */
    public List<T> loadData(Map<String, Object> params) throws Exception;

    /**
     * 更新元数据的标志位：如更具ID获取了元数据，处理完这批获取的数据后，ID要更新为最新的，不然下次又会拉到旧数据了
     * 
     * @throws Exception
     */
    public void updateData() throws Exception;

}
