/**
 * Project: xl-risk-control
 * 
 * File Created at 2015年3月12日
 * lizhaog
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.riskcontrol.data.provider;

/**
 * 如果是需要updateData的任务，建议单线程跑，避免多线程使用时更新标志位混乱
 * 
 * @author lizhaog
 */
public abstract class AbstractSourceDataProvider<T> implements SourceDataProvider<T> {

    /**
     * 注册provider
     */
    public AbstractSourceDataProvider() {
        SourceDataProviderFactory.register(getId(), this);
    }

    @Override
    public void updateData() throws Exception {
        // donothing
        // 有些按时间拉数据的任务，就不要做任何更新
    }

    public abstract String getId();
}
