/**
 * Project: xl-risk-control
 * 
 * File Created at 2015年3月19日
 * lizhaog
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.riskcontrol.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 序列化/反序列化工具
 * 
 * @author lizhaog
 */
public class SerializeUtil {

    private static Logger      logger  = LoggerFactory.getLogger(SerializeUtil.class);

    public static final String CHARSET = "UTF-8";

    private SerializeUtil() {
    }

    /**
     * 序列化
     * 
     * @param o
     * @return
     * @throws Exception
     */
    public static String serialize(Object o) throws Exception {
        if (o == null) {
            throw new NullPointerException("Can't serialize null");
        }
        byte[] rv = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream os = null;
        try {
            bos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bos);
            os.writeObject(o);
            os.close();
            bos.close();
            rv = bos.toByteArray();
        } catch (IOException e) {
            throw new IllegalArgumentException("Non-serializable object", e);
        } finally {
            close(os);
            close(bos);
        }
        return org.apache.axis.encoding.Base64.encode(rv);
    }

    /**
     * 反序列化
     * 
     * @param objectStr
     * @return
     */
    public static Object deserialize(String objectStr) {
        Object rv = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream is = null;
        try {
            byte[] in = org.apache.axis.encoding.Base64.decode(objectStr);
            if (in != null) {
                bis = new ByteArrayInputStream(in);
                is = new ObjectInputStream(bis);
                rv = is.readObject();
                is.close();
                bis.close();
            }
        } catch (Exception e) {
            logger.error("", e);
        } finally {
            close(is);
            close(bis);
        }
        return rv;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            } catch (Exception e) {
                logger.error("Unable to close " + e.getMessage(), e);
            }
        }
    }

}
