package com.xunlei.channel.riskcontrol.alarm.vo;

import java.util.Map;

/**
 * @author <a href="http://xiongyingqi.com">qi</a>
 * @version 2015-09-25 10:21
 */
public class AlarmStatusVo {
    /**
     * 是否需要预警
     */
    private boolean              isNeedAlarm;
    /**
     * 已经预警次数
     */
    private int                  checkFailTimes;
    private int                  failSize;
    private boolean              isSuccess;
    private Map<String, Integer> detailMap;

    public AlarmStatusVo() {
    }

    /**
     *
     * @param isNeedAlarm       是否需要预警 true/false
     * @param isSuccess         校验数据是否正确    true/false
     * @param checkFailTimes    检查失败次数
     * @param failSize          失败订单数量
     * @param detailMap
     */
    public AlarmStatusVo(boolean isNeedAlarm, boolean isSuccess, int checkFailTimes, int failSize, Map<String, Integer> detailMap) {
        this.isNeedAlarm = isNeedAlarm;
        this.isSuccess = isSuccess;
        this.checkFailTimes = checkFailTimes;
        this.failSize = failSize;
        this.detailMap = detailMap;
    }

    public boolean isNeedAlarm() {
        return isNeedAlarm;
    }

    public void setIsNeedAlarm(boolean isNeedAlarm) {
        this.isNeedAlarm = isNeedAlarm;
    }

    public int getCheckFailTimes() {
        return checkFailTimes;
    }

    public void setCheckFailTimes(int checkFailTimes) {
        this.checkFailTimes = checkFailTimes;
    }

    public boolean isSuccess() {
        return isSuccess;
    }

    public void setIsSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public int getFailSize() {
        return failSize;
    }

    public void setFailSize(int failSize) {
        this.failSize = failSize;
    }

    public Map<String, Integer> getDetailMap() {
        return detailMap;
    }

    public void setDetailMap(Map<String, Integer> detailMap) {
        this.detailMap = detailMap;
    }

    @Override
    public String toString() {
        return "AlarmStatusVo{" +
                "isNeedAlarm=" + isNeedAlarm +
                ", checkFailTimes=" + checkFailTimes +
                ", failSize=" + failSize +
                ", isSuccess=" + isSuccess +
                ", detailMap=" + detailMap +
                '}';
    }
}
