/**
 * Project: xl-risk-control
 * File Created at 15-9-18
 * qi
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.riskcontrol.alarm.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.Map;

/**
 * 模板工具
 *
 * @author <a href="http://xiongyingqi.com">qi</a>
 * @version 2015-09-18 16:58
 */
@Component
public class TemplateUtil {
    private static final Logger logger = LoggerFactory.getLogger(TemplateUtil.class);

    public String buildTemplate(String template, Map<String, String> params) throws Exception {
        Assert.hasText(template, "template is null");
        String rs = template;

        if(params != null){
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                rs = rs.replaceAll(buildParam(key), value);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("buildTemplate... template: {}, params: {}, result: {}", template, params, rs);
        }
        return rs;
    }

    /**
     * 参数匹配，匹配的格式： {param} 或者 { param} 或者 { param }
     * @param param 参数值
     * @return 返回{\s*param\s*}
     */
    protected String buildParam(String param) {
        return "\\{\\s*" + param + "\\s*}";
    }
}
