/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.task.impl;

import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.db.dao.RiskControlResultDAO;
import com.xunlei.channel.db.dao.RiskControlTaskDAO;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.db.pojo.RiskControlResult;
import com.xunlei.channel.db.pojo.RiskControlTask;
import com.xunlei.channel.riskcontrol.common.SerializeUtil;
import com.xunlei.channel.riskcontrol.constants.AlarmLevel;
import com.xunlei.channel.riskcontrol.constants.RiskResult;
import com.xunlei.channel.riskcontrol.eval.RiskControlEvaluator;
import com.xunlei.channel.riskcontrol.task.AbstractRiskTask;
import com.xunlei.channel.riskevaluator.constants.EvaluationCode;
import com.xunlei.channel.riskevaluator.context.EvalContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReCheckTask {
    private static final Logger logger = LoggerFactory.getLogger(ReCheckTask.class);
    @Autowired
    RiskControlResultDAO riskControlResultDAO;
    @Autowired
    protected RiskControlTaskDAO riskControlTaskDAO;
    @Autowired
    protected PayOrderDAO payOrderDAO;
    @Autowired
    protected PayOrderOkDAO payOrderOkDAO;
    @Autowired
    protected RiskControlEvaluator<Serializable> riskControlEvaluator;

    public void recheck() throws Exception {
        List datas = this.riskControlResultDAO.getRiskControlResultByValueAndAlarmLevel(RiskResult.FAIL.getCode(), new String[]{AlarmLevel.RECHECK.getLevel(), AlarmLevel.ALARM_NOW.getLevel()}, 500);
        if (logger.isInfoEnabled()) {
            logger.info("recheck task find {} datas", (Object)datas.size());
        }
        for (final RiskControlResult riskControlResult : datas) {
            if (logger.isInfoEnabled()) {
                logger.info("riskControlResult:dataId {};taskName {};errorCode {};resultDesc {} ", new Object[]{riskControlResult.getDataId(), riskControlResult.getTaskName(), riskControlResult.getErrorCode(), riskControlResult.getResultDesc()});
            }
            if ("ORDER_WAIT".equals(riskControlResult.getTaskName()) && EvaluationCode.ERROR_01.getCode().equals(riskControlResult.getErrorCode())) {
                PayOrder payOrder = this.payOrderDAO.getPayOrder(String.valueOf(riskControlResult.getDataId()));
                if (payOrder == null || !payOrder.getStatus().equals("S")) continue;
                riskControlResult.setAlarmLevel(AlarmLevel.RECHECK_SUCCESS.getLevel());
                riskControlResult.setResultValue(RiskResult.SUCCESS.getCode());
                riskControlResult.setErrorCode(null);
                riskControlResult.setResultDesc(riskControlResult.getResultDesc() + ";\u8ba2\u5355\u5df2\u5904\u7406\u6210\u529f");
                this.riskControlResultDAO.updateRiskControlResult(riskControlResult);
                continue;
            }
            if ("ORDER_OK".equals(riskControlResult.getTaskName()) && EvaluationCode.ERROR_03.getCode().equals(riskControlResult.getErrorCode())) {
                PayOrderOk payOrderOk = this.payOrderOkDAO.getPayOrderOk(String.valueOf(riskControlResult.getDataId()));
                if (payOrderOk == null || !payOrderOk.getSendNoticeStatus().equals("S")) continue;
                riskControlResult.setAlarmLevel(AlarmLevel.RECHECK_SUCCESS.getLevel());
                riskControlResult.setResultValue(RiskResult.SUCCESS.getCode());
                riskControlResult.setErrorCode(null);
                riskControlResult.setResultDesc(riskControlResult.getResultDesc() + ";\u901a\u77e5\u5f15\u64ce\u6210\u529f\u4e14\u8ba2\u5355\u5df2\u5904\u7406\u6210\u529f");
                this.riskControlResultDAO.updateRiskControlResult(riskControlResult);
                continue;
            }
            try {
                new AbstractRiskTask<Serializable>(this.riskControlTaskDAO, this.riskControlEvaluator){

                    @Override
                    protected List<Serializable> loadData(RiskControlTask riskControlTask, Map<String, Object> paramMap) throws Exception {
                        Serializable data = (Serializable)SerializeUtil.deserialize(riskControlResult.getData());
                        ArrayList<Serializable> list = new ArrayList<Serializable>();
                        list.add(data);
                        return list;
                    }

                    @Override
                    protected EvalContext initialEvalContext(Serializable data, Map<String, Object> paramMap, String rule) throws Exception {
                        EvalContext context = new EvalContext();
                        context.setId(riskControlResult.getDataId());
                        context.setData(paramMap);
                        context.setRule(rule);
                        return context;
                    }
                }.execute(riskControlResult.getTaskName());
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }
}

