/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.task;

import com.google.common.base.Strings;
import com.xunlei.channel.db.pojo.RiskControlTask;
import com.xunlei.channel.riskcontrol.data.provider.SourceDataProvider;
import com.xunlei.channel.riskcontrol.data.provider.SourceDataProviderFactory;
import com.xunlei.channel.riskcontrol.task.AbstractRiskTask;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSourceDataRiskTask<T extends Serializable>
extends AbstractRiskTask<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSourceDataRiskTask.class);

    @Override
    protected List<T> loadData(RiskControlTask riskControlTask, Map<String, Object> paramMap) throws Exception {
        String dataProviderId = riskControlTask.getTaskDataProvider();
        String taskName = riskControlTask.getTaskName();
        if (Strings.isNullOrEmpty((String)dataProviderId)) {
            logger.error("taskName:{} execute failed,invalid taskinfo[dataProviderId is empty] config in db:risk_control_task", (Object)taskName);
            throw new Exception("taskName:" + taskName + "execute failed,invalid taskinfo[dataProviderId is empty] config in db:risk_control_task");
        }
        SourceDataProvider<?> dataProvider = SourceDataProviderFactory.getRuleDataProvider(dataProviderId);
        if (dataProvider == null) {
            logger.error("taskName:{} execute failed,invalid taskinfo[dataProviderId:{}] config in db:risk_control_task", (Object)taskName, (Object)dataProviderId);
            throw new Exception("taskName:" + taskName + "execute failed,invalid taskinfo[dataProviderId:" + dataProviderId + "] config in db:risk_control_task");
        }
        return dataProvider.loadData(paramMap);
    }

    @Override
    protected void afterEval(RiskControlTask riskControlTask) throws Exception {
        String dataProviderId = riskControlTask.getTaskDataProvider();
        SourceDataProvider<?> dataProvider = SourceDataProviderFactory.getRuleDataProvider(dataProviderId);
        dataProvider.updateData();
    }
}

