/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.task;

import com.google.common.base.Strings;
import com.xunlei.channel.db.dao.RiskControlTaskDAO;
import com.xunlei.channel.db.pojo.RiskControlTask;
import com.xunlei.channel.paycommon.util.string.StringUtils;
import com.xunlei.channel.riskcontrol.eval.RiskControlEvaluator;
import com.xunlei.channel.riskcontrol.task.RiskTask;
import com.xunlei.channel.riskevaluator.context.EvalContext;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRiskTask<T>
implements RiskTask<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRiskTask.class);
    @Autowired
    protected RiskControlTaskDAO riskControlTaskDAO;
    @Autowired
    protected RiskControlEvaluator<T> riskControlEvaluator;

    public AbstractRiskTask() {
    }

    public AbstractRiskTask(RiskControlTaskDAO riskControlTaskDAO, RiskControlEvaluator<T> riskControlEvaluator) {
        this.riskControlTaskDAO = riskControlTaskDAO;
        this.riskControlEvaluator = riskControlEvaluator;
    }

    @Override
    public void execute(String taskName) throws Exception {
        Map paramMap;
        RiskControlTask riskControlTask = this.validateRiskTaskInfo(taskName);
        List<T> datas = this.loadData(riskControlTask, paramMap = StringUtils.stringToMap((String)riskControlTask.getTaskParams(), (String)"&"));
        if (datas != null && datas.size() > 0) {
            try {
                for (T data : datas) {
                    EvalContext context = this.initialEvalContext(data, paramMap, riskControlTask.getRuleValue());
                    this.riskControlEvaluator.evalAndProcessEvalResult(context, taskName, data);
                }
                this.afterEval(riskControlTask);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                throw new Exception("taskName:" + taskName + "execute failed,with errmsg:" + e.getMessage());
            }
        } else {
            logger.info("execute taskName:{} find 0 source data to risk", (Object)taskName);
        }
    }

    protected RiskControlTask validateRiskTaskInfo(String taskName) throws Exception {
        RiskControlTask riskControlTask = this.riskControlTaskDAO.getRiskControlTaskByName(taskName);
        if (riskControlTask == null) {
            logger.error("taskName:{} execute failed,cant find taskinfo config in db:risk_control_task", (Object)taskName);
            throw new Exception("taskName:" + taskName + "execute failed,cant find taskinfo config in db:risk_control_task");
        }
        String rule = riskControlTask.getRuleValue();
        if (Strings.isNullOrEmpty((String)rule)) {
            logger.error("taskName:{} execute failed,invalid taskinfo[rule is empty] config in db:risk_control_task", (Object)taskName);
            throw new Exception("taskName:" + taskName + "execute failed,invalid taskinfo[rule is empty] config in db:risk_control_task");
        }
        return riskControlTask;
    }

    protected abstract List<T> loadData(RiskControlTask var1, Map<String, Object> var2) throws Exception;

    protected abstract EvalContext initialEvalContext(T var1, Map<String, Object> var2, String var3) throws Exception;

    protected void afterEval(RiskControlTask riskControlTask) throws Exception {
    }
}

