/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.common;

import com.xunlei.channel.db.dao.ConfigInfoDAO;
import com.xunlei.channel.db.pojo.ConfigInfo;
import com.xunlei.channel.paycommon.configcache.ConfigCacheClientProxy;
import com.xunlei.channel.paycommon.configcache.vo.CacheKey;
import com.xunlei.channel.paycommon.configcache.vo.CacheValue;
import com.xunlei.channel.paycommon.util.string.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigInfoUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigInfoUtils.class);
    @Autowired
    ConfigInfoDAO configInfoDAO;
    @Autowired
    ConfigCacheClientProxy configCacheClientProxy;

    public String getConfigValue(String groupId, String propertyKey) {
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{groupId, propertyKey})) {
            logger.info("groupId:{} or propertyKey:{} is null,return null", (Object)groupId, (Object)propertyKey);
            return null;
        }
        CacheKey cacheKey = new CacheKey(groupId, propertyKey);
        CacheValue cacheValue = this.configCacheClientProxy.get(cacheKey);
        String value = null;
        if (cacheValue == null) {
            value = this.getConfigInfoFromDB(groupId, propertyKey);
            logger.debug("get groupId:{},propertyKey:{} from db with resp value:{}", new Object[]{groupId, propertyKey, value});
            if (value != null) {
                this.configCacheClientProxy.put(cacheKey, new CacheValue(value));
            }
        } else {
            value = cacheValue.getPropertyValue();
            logger.debug("get groupId:{},propertyKey:{} from cache with resp value:{}", new Object[]{groupId, propertyKey, value});
        }
        return value;
    }

    public boolean updateConfigValue(String groupId, String propertyKey, String value) {
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{groupId, propertyKey, value})) {
            logger.info("groupId:{} or propertyKey:{} is null,return null", (Object)groupId, (Object)propertyKey);
            return false;
        }
        CacheKey cacheKey = new CacheKey(groupId, propertyKey);
        CacheValue cacheValue = new CacheValue(value);
        boolean updateCache = this.configCacheClientProxy.put(cacheKey, cacheValue);
        boolean updateDb = this.updateConfigInfoToDB(groupId, propertyKey, value);
        logger.info("updateCache result:{},updateDb result:{} for groupId:{},propertyKey:{}", new Object[]{updateCache, updateDb, groupId, propertyKey});
        return updateCache && updateDb;
    }

    private String getConfigInfoFromDB(String groupId, String propertyKey) {
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setGroupId(groupId);
        configInfo.setInUse("Y");
        configInfo.setPropertyKey(propertyKey);
        List list = this.configInfoDAO.getConfigInfo(configInfo);
        if (list.size() > 0) {
            return ((ConfigInfo)list.get(0)).getPropertyValue();
        }
        return null;
    }

    private boolean updateConfigInfoToDB(String groupId, String propertyKey, String value) {
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setGroupId(groupId);
        configInfo.setInUse("Y");
        configInfo.setPropertyKey(propertyKey);
        try {
            List list = this.configInfoDAO.getConfigInfo(configInfo);
            if (list.size() > 0) {
                configInfo = (ConfigInfo)list.get(0);
                configInfo.setPropertyValue(value);
                this.configInfoDAO.updateConfigInfo(configInfo);
                return true;
            }
            logger.info("cant find configinfo in db by groupId:{},propertyKey:{}", (Object)groupId, (Object)propertyKey);
            return false;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return false;
        }
    }
}

