/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.alarm.util;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class TemplateUtil {
    private static final Logger logger = LoggerFactory.getLogger(TemplateUtil.class);

    public String buildTemplate(String template, Map<String, String> params) throws Exception {
        Assert.hasText((String)template, (String)"template is null");
        String rs = template;
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                rs = rs.replaceAll(this.buildParam(key), value);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("buildTemplate... template: {}, params: {}, result: {}", new Object[]{template, params, rs});
        }
        return rs;
    }

    protected String buildParam(String param) {
        return "\\{\\s*" + param + "\\s*}";
    }
}

