/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.alarm.service.impl;

import com.xunlei.channel.alarm.api.AlarmApi;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmData;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmItem;
import com.xunlei.channel.alarmcenter.receive.pojo.AlarmReceiveResult;
import com.xunlei.channel.riskcontrol.alarm.processor.MessageProcessor;
import com.xunlei.channel.riskcontrol.alarm.service.AlarmService;
import com.xunlei.channel.riskcontrol.alarm.util.TemplateUtil;
import com.xunlei.channel.riskcontrol.alarm.vo.AlarmStatusVo;
import com.xunlei.channel.riskcontrol.util.MapperFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AlarmServiceImpl
implements AlarmService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AlarmServiceImpl.class);
    @Value(value="#{alarm['alarm.alarmId']}")
    private String alarmId;
    @Value(value="#{alarm['alarm.alarmName']}")
    private String alarmName;
    @Value(value="#{alarm['alarm.description']}")
    private String alarmDescription;
    @Value(value="#{alarm['alarm.strategy']}")
    private String alarmStrategy;
    @Value(value="#{alarm['alarm.owner']}")
    private String alarmOwner;
    @Value(value="#{alarm['alarm.inUse']}")
    private boolean alarmInUse;
    @Value(value="#{alarm['alarm.groupId']}")
    private String alarmGroupId;
    @Value(value="#{alarm['api.baseUrl']}")
    private String alarmBaseUrl;
    @Value(value="#{alarm['template.messageTemplate']}")
    public String template;
    @Value(value="#{alarm['template.successMessageTemplate']}")
    public String successMessageTemplate;
    private AlarmApi alarmApi;
    @Autowired
    private MessageProcessor messageProcessor;
    @Autowired
    private TemplateUtil templateUtil;

    private void initAlarm() {
        try {
            this.alarmApi = new AlarmApi(this.alarmBaseUrl);
        }
        catch (Exception e) {
            logger.error("init alarmApi error!", (Throwable)e);
        }
        try {
            AlarmItem alarmItem = new AlarmItem();
            alarmItem.setAlarmId(this.alarmId);
            alarmItem.setDescription(this.alarmDescription);
            alarmItem.setInUse(Boolean.valueOf(this.alarmInUse));
            alarmItem.setName(this.alarmName);
            alarmItem.setOwner(this.alarmOwner);
            alarmItem.setStrategy(this.alarmStrategy);
            this.alarmApi.setAlarmItem(alarmItem);
        }
        catch (Exception e) {
            logger.error("init AlarmService error! ", (Throwable)e);
        }
    }

    public String buildDetail(Map<String, Integer> detailMap) {
        if (detailMap == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\r\n");
        for (Map.Entry<String, Integer> entry : detailMap.entrySet()) {
            builder.append(entry.getKey());
            builder.append(": ");
            builder.append(entry.getValue());
            builder.append("\r\n");
        }
        builder.delete(builder.length() - 2, builder.length());
        return builder.toString();
    }

    @Override
    public void alarm() {
        AlarmStatusVo alarmStatusVo = this.messageProcessor.isAlarm();
        if (alarmStatusVo == null || !alarmStatusVo.isNeedAlarm()) {
            if (logger.isInfoEnabled()) {
                logger.info("alarm... not need alarm!");
            }
            return;
        }
        if (alarmStatusVo.isSuccess()) {
            if (logger.isInfoEnabled()) {
                logger.info("alarm...  check success! send template: {}", (Object)this.successMessageTemplate);
            }
            this.sendAlarm(this.successMessageTemplate);
        } else {
            Map<String, Integer> detailMap = alarmStatusVo.getDetailMap();
            Integer failOrderNum = alarmStatusVo.getFailSize();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("failTimes", alarmStatusVo.getCheckFailTimes() + "");
            params.put("failOrderNum", failOrderNum + "");
            params.put("detail", this.buildDetail(detailMap));
            try {
                String s = this.templateUtil.buildTemplate(this.template, params);
                if (logger.isInfoEnabled()) {
                    logger.info("alarm... template: {}, detailMap: {}, result: {}", new Object[]{this.template, detailMap, s});
                }
                this.sendAlarm(s);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    private void sendAlarm(String content) {
        AlarmData alarmData = new AlarmData();
        alarmData.setAlarmId(this.alarmId);
        alarmData.setContent(content);
        alarmData.setGroupId(this.alarmGroupId);
        try {
            AlarmReceiveResult receiveResult = this.alarmApi.addAlarmData(alarmData);
            boolean b = this.alarmApi.isSuccess(receiveResult);
            if (b) {
                if (logger.isDebugEnabled()) {
                    logger.debug("sendAlarm... alarm success! alarmData: {}", (Object)MapperFactory.getObjectMapper().writeValueAsString((Object)alarmData));
                }
            } else {
                logger.error("sendAlarm... alarm failed! alarmData: {}", (Object)MapperFactory.getObjectMapper().writeValueAsString((Object)alarmData));
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.initAlarm();
    }

    public static void main(String[] args) {
        long second = 1000L;
        long minute = 60L * second;
        long hour = 60L * minute;
        System.out.println(hour);
    }
}

