package com.xunlei.netty.httpserver.util.spring;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import com.xunlei.netty.httpserver.Bootstrap;

/**
 * @author wangcanyi
 *
 */
public class SpringBootstrap {

	private static ApplicationContext CONTEXT;

	/**
	 * 加载ApplicationContext
	 * 
	 * @param springConfigLocations ApplicationContext.xml地址
	 * @return
	 */
	public static ApplicationContext load(String... springConfigLocations) {
		if (CONTEXT != null) {
			throw new IllegalAccessError("SpringBootstrap.CONTEXT is setted,you should start app by SpringBootstrap.main() only once");
		}
		ApplicationContext context = CONTEXT = new ClassPathXmlApplicationContext(springConfigLocations);
		Bootstrap.CONTEXT = context; // 为了兼容老的CONTEXT
		ConfigBeanPostProcessor pp = BeanUtil.getTypedBean(context, "configBeanPostProcessor");
		pp.postProcessAfterBootstrap(context);// 真正使用Bootstrap来调AfterConfig
		return context;
	}

	/**
	 * 获取当前ApplicationContext
	 * 
	 * @return
	 */
	public static ApplicationContext getContext() {
		if (CONTEXT == null) {
			throw new NullPointerException("SpringBootstrap.CONTEXT is null,solution:you should start app by SpringBootstrap.load()");
		}
		return CONTEXT;
	}

}
