package com.xunlei.netty.httpserver.util;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import com.sun.management.GcInfo;

/**
 * @author ZengDong
 * @since 2011-12-17 上午12:24:38
 */
public class SystemInfo {

    private static String serverStartupTime;// 服务器启动时间
    /** 服务器的启动类 */
    public static final String LAUNCHER_NAME;
    public static final int PID;
    public static final String HOSTNAME;
    public static final String COMMAND_FULL;
    public static final String COMMAND;
    public static final String COMMAND_SHORT;

    static {
        String sunjavacommand = System.getProperty("sun.java.command");
        String command_full = "";
        String command_short = "";
        String command = "";
        if (StringTools.isNotEmpty(sunjavacommand)) {
            command_full = sunjavacommand;
            command = command_full.split(" ")[0];
            command_short = command.substring(command.lastIndexOf('.') + 1);
        }
        COMMAND_FULL = command_full;
        COMMAND = command;
        COMMAND_SHORT = command_short;

        String launcher_name = ManagementFactory.getRuntimeMXBean().getName();
        // 尽量去掉Launch让标题能更短一点
        command_short = !"Launch".equals(command_short) && command_short.endsWith("Launch") ? command_short.substring(0, command_short.length() - "Launch".length()) : command_short;
        String hostName = "UNKNOWN";
        int pid = -1;
        String ip = HttpUtil.getLocalSampleIP();
        String pidAtHostName = ManagementFactory.getRuntimeMXBean().getName();
        int idx = pidAtHostName.indexOf('@');
        if (idx > 0) {
            pid = ValueUtil.getInteger(pidAtHostName.substring(0, idx), pid);
            hostName = pidAtHostName.substring(idx + 1);
        }
        // 不展示pid，目的也是让标题更短一点
        // String first = StringTools.isEmpty(command_short) ? pid + "" : command_short + "<" + pid + ">";
        String first = command_short;
        // 如果是内网机器 IP段为192.168/10.10的，就只显示IP否则就认为是外网机器显示机器名，方便查问题
        // String second = hostName + "<" + ip + ">";
        String second = ip.startsWith("192.168.") || ip.startsWith("10.10.") ? ip : hostName;
        launcher_name = first + "@" + second;
        PID = pid;
        HOSTNAME = hostName;
        LAUNCHER_NAME = launcher_name;
        // System.err.println(launcher_name_tmp);
    }

    private static String formatMemoryUsage(MemoryUsage mem) {
        String fmt = "初始化:%-10s 已使用:%-10s 最大:%-10s";
        return String.format(fmt, HumanReadableUtil.byteSize(mem.getInit()), HumanReadableUtil.byteSize(mem.getUsed()), HumanReadableUtil.byteSize(mem.getMax()));
    }

    private static String getContrastString(long before, long after) {
        long sub = after - before;
        if (sub > 0) {
            return "↑" + HumanReadableUtil.byteSize(after);
        } else if (sub < 0) {
            return "↓" + HumanReadableUtil.byteSize(after);
        }
        return "";
    }

    public static StringBuilder getGarbageCollectorInfo(StringBuilder tmp) {
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        tmp.append("GarbageCollectorMXBeans\n");
        String gcFmt = "%-23s %-8s %-20s %s\n";
        tmp.append(String.format(gcFmt, "GCName", "Count", "Time", "MemoryPoolNames"));
        Set<String> poolNames = new LinkedHashSet<String>();
        for (GarbageCollectorMXBean gc : gcs) {
            tmp.append(String.format(gcFmt, gc.getName(), gc.getCollectionCount(), HumanReadableUtil.timeSpan(gc.getCollectionTime()), Arrays.toString(gc.getMemoryPoolNames())));
            for (String n : gc.getMemoryPoolNames()) {
                poolNames.add(n);
            }
        }
        gcFmt = "%-23s %-5s %-20s %-20s %s\n";
        long serverStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        tmp.append(String.format(gcFmt, "+ LastGcInfo", "Id", "StartTime", "EndTime", "Duration"));
        for (GarbageCollectorMXBean gc : gcs) {
            if (gc instanceof com.sun.management.GarbageCollectorMXBean) {
                com.sun.management.GarbageCollectorMXBean g = (com.sun.management.GarbageCollectorMXBean) gc;
                GcInfo gi = g.getLastGcInfo();
                if (gi == null || gi.getStartTime() == 0) {
                    continue;
                }
                DateStringUtil dsu = DateStringUtil.getInstance("HH:mm:ss.S");
                String start = dsu.format(new Date(serverStartTime + gi.getStartTime()));
                String end = dsu.format(new Date(serverStartTime + gi.getEndTime()));
                tmp.append(String.format(gcFmt, "  " + gc.getName(), gi.getId(), start, end, HumanReadableUtil.timeSpan(gi.getDuration())));
                Map<String, MemoryUsage> before = gi.getMemoryUsageBeforeGc();
                Map<String, MemoryUsage> after = gi.getMemoryUsageAfterGc();
                String muFmt = "%-23s %-30s %-14s %-14s %-14s %-14s\n";
                tmp.append(String.format(muFmt, "", "poolName", "init", "used", "committed", "max"));
                for (String name : poolNames) {
                    // for (java.util.Map.Entry<String, MemoryUsage> e : before.entrySet()) {
                    // String name = e.getKey();
                    // MemoryUsage mu = e.getValue();
                    MemoryUsage mu = before.get(name);
                    MemoryUsage mu1 = after.get(name);
                    if (mu == null) {
                        continue;
                    }
                    tmp.append(String.format(muFmt, "", name, HumanReadableUtil.byteSize(mu.getInit()), HumanReadableUtil.byteSize(mu.getUsed()), HumanReadableUtil.byteSize(mu.getCommitted()),
                            HumanReadableUtil.byteSize(mu.getMax())));
                    String init = getContrastString(mu.getInit(), mu1.getInit());
                    String used = getContrastString(mu.getUsed(), mu1.getUsed());
                    String committted = getContrastString(mu.getCommitted(), mu1.getCommitted());
                    String max = getContrastString(mu.getMax(), mu1.getMax());
                    tmp.append(String.format(muFmt, "", "", init, used, committted, max));
                }
            }
        }
        return tmp;
    }

    public static StringBuilder getMemoryInfo(StringBuilder tmp) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        tmp.append("\nmemoryMXBean\n");
        tmp.append("已使用内存:\t\t").append(HumanReadableUtil.byteSize(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())).append("\n");
        tmp.append("已分配内存:\t\t").append(HumanReadableUtil.byteSize(Runtime.getRuntime().totalMemory())).append("\n");
        tmp.append("最大内存:\t\t").append(HumanReadableUtil.byteSize(Runtime.getRuntime().maxMemory())).append("\n");
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        tmp.append("堆内存:\t\t\t").append(formatMemoryUsage(memoryMXBean.getHeapMemoryUsage())).append("\n");
        tmp.append("非堆内存:\t\t").append(formatMemoryUsage(memoryMXBean.getNonHeapMemoryUsage())).append("\n");
        tmp.append("待回收对象数:\t\t").append(memoryMXBean.getObjectPendingFinalizationCount()).append("\n");
        tmp.append("\n");
        return tmp;
    }

    public static String getServerStartupTime() {
        if (serverStartupTime == null) {
            serverStartupTime = DateStringUtil.DEFAULT.format(new Date(ManagementFactory.getRuntimeMXBean().getStartTime()));
        }
        return serverStartupTime;
    }

    public static String getSytemInfo() {
        StringBuilder tmp = new StringBuilder();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        tmp.append("runtimeMXBean\n");
        tmp.append("启动时间:\t\t").append(getServerStartupTime()).append("\n");
        tmp.append("已运行:\t\t\t").append(HumanReadableUtil.timeSpan(runtimeMXBean.getUptime())).append("\n");
        tmp.append("进程:\t\t\t").append(runtimeMXBean.getName()).append("\n");
        tmp.append("名称:\t\t\t").append(LAUNCHER_NAME).append("\n");
        tmp.append("虚拟机:\t\t\t").append(runtimeMXBean.getVmName()).append(" ").append(runtimeMXBean.getVmVersion()).append("\n");

        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        tmp.append("\n");
        tmp.append("ThreadMXBean\n");
        tmp.append("当前线程数:\t\t").append(threadMXBean.getThreadCount()).append("\n");
        tmp.append("后台线程数:\t\t").append(threadMXBean.getDaemonThreadCount()).append("\n");
        tmp.append("峰值线程数:\t\t").append(threadMXBean.getPeakThreadCount()).append("\n");
        tmp.append("已启动线程数:\t\t").append(threadMXBean.getTotalStartedThreadCount()).append("\n");
        tmp.append("\n");

        getMemoryInfo(tmp);
        getGarbageCollectorInfo(tmp);

        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        tmp.append("\n");
        tmp.append("operatingSystemMXBean\n");
        tmp.append("操作系统:\t\t").append(operatingSystemMXBean.getName()).append(" ").append(operatingSystemMXBean.getVersion()).append("\n");
        tmp.append("体系结构:\t\t").append(operatingSystemMXBean.getArch()).append("\n");
        tmp.append("处理器个数:\t\t").append(operatingSystemMXBean.getAvailableProcessors()).append("\n");
        return tmp.toString();
    }
}
