package com.xunlei.netty.httpserver.cmd.common;

import org.springframework.stereotype.Service;

import com.xunlei.netty.httpserver.cmd.BaseCmd;
import com.xunlei.netty.httpserver.cmd.annotation.CmdAdmin;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.component.XLHttpResponse.ContentType;
import com.xunlei.netty.httpserver.util.spring.Config;

/**
 * @author ZengDong
 * @since 2010-3-18 下午01:43:24
 */
@Service
public class EchoCmd extends BaseCmd {

    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        response.setInnerContentType(ContentType.plain);
        StringBuilder responseContent = new StringBuilder();
        responseContent.append("WELCOME TO THE XUNLEI HTTPSERVER\n");
        responseContent.append(request.getDetailInfo());

        return responseContent.toString();
    }
}
