/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util.spring;

import com.xunlei.netty.httpserver.util.Log;
import com.xunlei.netty.httpserver.util.spring.SpringBootstrap;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class BeanUtil {
    private static final Set<Type> basicTypes = new HashSet<Type>();
    private static final Logger log = Log.getLogger();

    public static <T> T getTypedBean(ApplicationContext context, Class<T> clazz) throws BeansException {
        int i$ = 0;
        String[] arr$ = context.getBeanNamesForType(clazz);
        int len$ = arr$.length;
        if (i$ < len$) {
            String name = arr$[i$];
            return (T)context.getBean(name);
        }
        return null;
    }

    public static <T> T getTypedBean(ApplicationContext context, String name) throws BeansException {
        return (T)context.getBean(name);
    }

    public static <T> T getTypedBean(Class<T> clazz) throws BeansException {
        return BeanUtil.getTypedBean(SpringBootstrap.getContext(), clazz);
    }

    public static <T> T getTypedBean(String name) throws BeansException {
        return BeanUtil.getTypedBean(SpringBootstrap.getContext(), name);
    }

    public static <T> Map<String, T> getTypedBeans(ApplicationContext context, Class<T> clazz) throws BeansException {
        Map map = context.getBeansOfType(clazz);
        HashMap r = new HashMap();
        for (Map.Entry e : map.entrySet()) {
            String beanName = e.getKey().toString();
            Object bean = e.getValue();
            r.put(beanName, bean);
        }
        return r;
    }

    public static <T> Map<String, T> getTypedBeans(Class<T> clazz) throws BeansException {
        return BeanUtil.getTypedBeans(SpringBootstrap.getContext(), clazz);
    }

    public static <T> T getTypedBeanSilently(Class<T> clazz) {
        try {
            return BeanUtil.getTypedBean(clazz);
        }
        catch (Throwable e) {
            log.info("{}", (Object)e.toString());
            return null;
        }
    }

    public static <T> T getTypedBeanSilently(String name) {
        try {
            return BeanUtil.getTypedBean(name);
        }
        catch (Throwable e) {
            log.info("{}", (Object)e.toString());
            return null;
        }
    }

    public static <T> Map<String, T> getTypedBeansSilently(Class<T> clazz) {
        try {
            return BeanUtil.getTypedBeans(clazz);
        }
        catch (Throwable e) {
            log.info("{}", (Object)e.toString());
            return null;
        }
    }

    public static boolean isBasicType(Type clazz) {
        return basicTypes.contains(clazz);
    }

    public static boolean isNotBasicType(Type clazz) {
        return !BeanUtil.isBasicType(clazz);
    }

    static {
        basicTypes.add(Integer.TYPE);
        basicTypes.add((Type)((Object)Integer.class));
        basicTypes.add(Long.TYPE);
        basicTypes.add((Type)((Object)Long.class));
        basicTypes.add(Float.TYPE);
        basicTypes.add((Type)((Object)Float.class));
        basicTypes.add(Double.TYPE);
        basicTypes.add((Type)((Object)Double.class));
        basicTypes.add(Short.TYPE);
        basicTypes.add((Type)((Object)Short.class));
        basicTypes.add(Boolean.TYPE);
        basicTypes.add((Type)((Object)Boolean.class));
        basicTypes.add(Character.TYPE);
        basicTypes.add((Type)((Object)Character.class));
        basicTypes.add(Byte.TYPE);
        basicTypes.add((Type)((Object)Byte.class));
        basicTypes.add((Type)((Object)String.class));
    }
}

