/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util.concurrent;

import com.xunlei.netty.httpserver.util.HumanReadableUtil;
import com.xunlei.netty.httpserver.util.concurrent.NamedThreadFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentUtil {
    public static final ThreadPoolExecutor.CallerRunsPolicy callerRunsPolicy = new ThreadPoolExecutor.CallerRunsPolicy();
    public static final int CORE_PROCESSOR_NUM = Runtime.getRuntime().availableProcessors();
    private static ScheduledExecutorService daemonExecutor;
    private static ExecutorService defaultExecutor;
    public static final RejectedExecutionHandler discardPolicy;
    private static final String executorStatFmt = "%-23s %-13s %-12s %-16s %-12s %-12s %-18s %-16s %-16s %-16s %-12s\n";
    private static final String executorStatHeader;
    private static ExecutorService logExecutor;
    private static final String PREFIX = "";
    private static final ScheduledExecutorService watchdog;
    private static final Collection<Number> atomicCounterList;
    public static int atomicCounterScanHour;
    public static int atomicCounterResetThreshold;

    public static void main(String[] args) {
        System.out.println(Integer.MAX_VALUE);
        System.out.println(Long.MAX_VALUE);
    }

    public static String getAllExecutorInfo(ExecutorService ... executors) {
        return ConcurrentUtil.getExecutorInfo(ConcurrentUtil.getAllExecutors(executors));
    }

    public static boolean threadSleep(long millis) {
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException e1) {
            return false;
        }
    }

    public static ExecutorService[] getAllExecutors(ExecutorService ... executors) {
        ExecutorService[] arr = new ExecutorService[4 + executors.length];
        int i = 0;
        arr[i++] = watchdog;
        arr[i++] = daemonExecutor;
        arr[i++] = defaultExecutor;
        arr[i++] = logExecutor;
        for (ExecutorService e : executors) {
            arr[i++] = e;
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScheduledExecutorService getDaemonExecutor() {
        if (daemonExecutor != null) return daemonExecutor;
        Class<ConcurrentUtil> clazz = ConcurrentUtil.class;
        synchronized (ConcurrentUtil.class) {
            if (daemonExecutor != null) return daemonExecutor;
            daemonExecutor = Executors.newScheduledThreadPool(CORE_PROCESSOR_NUM, new NamedThreadFactory("Daemon(Sche)", 5, true));
            // ** MonitorExit[var0] (shouldn't be in output)
            return daemonExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getDefaultExecutor() {
        if (defaultExecutor != null) return defaultExecutor;
        Class<ConcurrentUtil> clazz = ConcurrentUtil.class;
        synchronized (ConcurrentUtil.class) {
            if (defaultExecutor != null) return defaultExecutor;
            defaultExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("Default", 5));
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultExecutor;
        }
    }

    public static String getExecutorInfo(ExecutorService ... executors) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(executorStatHeader);
        for (ExecutorService e : executors) {
            if (e == null) continue;
            String executorName = ConcurrentUtil.getExecutorName(e);
            if (e instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor executor = (ThreadPoolExecutor)e;
                tmp.append(String.format(executorStatFmt, executorName, executor.getActiveCount(), executor.getPoolSize(), executor.getLargestPoolSize(), executor.getQueue().size(), executor.getTaskCount(), executor.getCompletedTaskCount(), executor.getCorePoolSize(), executor.getMaximumPoolSize(), HumanReadableUtil.timeSpan(executor.getKeepAliveTime(TimeUnit.MILLISECONDS)), executor.allowsCoreThreadTimeOut()));
                continue;
            }
            tmp.append("!!!").append(executorName);
        }
        return tmp.toString();
    }

    public static String getExecutorName(ExecutorService e) {
        NamedThreadFactory tf = ConcurrentUtil.getNamedExecutorThreadFactory(e);
        return tf == null ? e.getClass().getSimpleName() : tf.getNamePrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getLogExecutor() {
        if (logExecutor != null) return logExecutor;
        Class<ConcurrentUtil> clazz = ConcurrentUtil.class;
        synchronized (ConcurrentUtil.class) {
            if (logExecutor != null) return logExecutor;
            int num = (int)Math.round(Math.sqrt(CORE_PROCESSOR_NUM));
            logExecutor = new ThreadPoolExecutor(num, num, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("Log", 1));
            // ** MonitorExit[var0] (shouldn't be in output)
            return logExecutor;
        }
    }

    public static NamedThreadFactory getNamedExecutorThreadFactory(ExecutorService e) {
        ThreadPoolExecutor executor;
        ThreadFactory tf;
        if (e instanceof ThreadPoolExecutor && (tf = (executor = (ThreadPoolExecutor)e).getThreadFactory()) instanceof NamedThreadFactory) {
            return (NamedThreadFactory)tf;
        }
        return null;
    }

    public static ScheduledExecutorService getWatchdog() {
        return watchdog;
    }

    public static AtomicInteger newAtomicInteger() {
        AtomicInteger i = new AtomicInteger();
        atomicCounterList.add(i);
        return i;
    }

    public static AtomicLong newAtomicLong() {
        AtomicLong i = new AtomicLong();
        atomicCounterList.add(i);
        return i;
    }

    public static void parallel(ParalleledJob ... pj) {
        Thread.currentThread().setPriority(10);
        if (pj.length > 0) {
            CountDownLatch latch = new CountDownLatch(pj.length);
            for (ParalleledJob j : pj) {
                j.latch = latch;
                ConcurrentUtil.getDefaultExecutor().execute(j);
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            for (ParalleledJob j : pj) {
                if (null == j.throwable) continue;
                throw new RuntimeException(j.throwable);
            }
        }
        Thread.currentThread().setPriority(5);
    }

    private ConcurrentUtil() {
    }

    static {
        discardPolicy = new ThreadPoolExecutor.DiscardPolicy();
        executorStatHeader = String.format(executorStatFmt, "Executor", "activeCount", "poolSize", "largestPoolSize", "queueSize", "taskCount", "completedTaskCount", "corePoolSize", "maximumPoolSize", "keepAliveTime", "coreTimeOut");
        watchdog = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("Watchdog(Sche)", 5, true));
        atomicCounterList = new HashSet<Number>();
        atomicCounterScanHour = 2;
        atomicCounterResetThreshold = 0x3FFFFFFF;
        ConcurrentUtil.getDaemonExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                int integerMax = Integer.MAX_VALUE - atomicCounterResetThreshold;
                long longMax = Long.MAX_VALUE - (long)atomicCounterResetThreshold;
                for (Number n : atomicCounterList) {
                    Number i;
                    if (n instanceof AtomicInteger) {
                        i = (AtomicInteger)n;
                        if (((AtomicInteger)i).get() <= integerMax) continue;
                        ((AtomicInteger)i).set(0);
                        continue;
                    }
                    if (!(n instanceof AtomicLong) || ((AtomicLong)(i = (AtomicLong)n)).get() <= longMax) continue;
                    ((AtomicLong)i).set(0L);
                }
            }
        }, atomicCounterScanHour, atomicCounterScanHour, TimeUnit.HOURS);
    }

    public static abstract class ParalleledJob
    implements Runnable {
        private CountDownLatch latch;
        private Throwable throwable;

        public abstract void job() throws Throwable;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                this.job();
            }
            catch (Throwable t) {
                this.throwable = t;
            }
            finally {
                if (null != this.latch) {
                    this.latch.countDown();
                }
            }
        }
    }
}

