/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import com.xunlei.netty.httpserver.util.StringTools;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ValueUtil {
    public static final String[] REF_ARRAY_STRING = new String[0];
    public static final Boolean[] REF_ARRAY_BOOLEAN = new Boolean[0];
    public static final Byte[] REF_ARRAY_BYTE = new Byte[0];
    public static final Character[] REF_ARRAY_CHARACTER = new Character[0];
    public static final Short[] REF_ARRAY_SHORT = new Short[0];
    public static final Integer[] REF_ARRAY_INTEGER = new Integer[0];
    public static final Long[] REF_ARRAY_LONG = new Long[0];
    public static final Float[] REF_ARRAY_FLOAT = new Float[0];
    public static final Double[] REF_ARRAY_DOUBLE = new Double[0];
    private static final IllegalArgumentException classNotBasicTypeException = new IllegalArgumentException("classNotBasicType");
    private static final Map<Type, Method> valueOfMethod = ValueUtil.initValueOfMethod();

    public static boolean getBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true") || value.equalsIgnoreCase("y") || value.equals("1");
    }

    public static byte getByte(String value, byte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Byte.valueOf(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Character getCharacter(String str) {
        return Character.valueOf(str.charAt(0));
    }

    public static char getCharacter(String value, char defaultValue) {
        if (StringTools.isEmpty(value)) {
            return defaultValue;
        }
        return value.charAt(0);
    }

    public static double getDouble(String value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.valueOf(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static float getFloat(String value, float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(value).floatValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getInteger(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getLong(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.valueOf(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static short getShort(String value, short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Short.valueOf(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getString(String value, String defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    protected static Method getValueOfMethod(Class<?> clazz) {
        Method m = valueOfMethod.get(clazz);
        if (m == null) {
            throw classNotBasicTypeException;
        }
        return m;
    }

    private static Map<Type, Method> initValueOfMethod() {
        HashMap<Type, Method> valueOfMethods = new HashMap<Type, Method>();
        try {
            valueOfMethods.put(Integer.TYPE, Integer.class.getMethod("valueOf", String.class));
            valueOfMethods.put((Type)((Object)Integer.class), Integer.class.getMethod("valueOf", String.class));
            valueOfMethods.put(Long.TYPE, Long.class.getMethod("valueOf", String.class));
            valueOfMethods.put((Type)((Object)Long.class), Long.class.getMethod("valueOf", String.class));
            valueOfMethods.put(Float.TYPE, Float.class.getMethod("valueOf", String.class));
            valueOfMethods.put((Type)((Object)Float.class), Float.class.getMethod("valueOf", String.class));
            valueOfMethods.put(Double.TYPE, Double.class.getMethod("valueOf", String.class));
            valueOfMethods.put((Type)((Object)Double.class), Double.class.getMethod("valueOf", String.class));
            valueOfMethods.put(Short.TYPE, Short.class.getMethod("valueOf", String.class));
            valueOfMethods.put((Type)((Object)Short.class), Short.class.getMethod("valueOf", String.class));
            valueOfMethods.put(Boolean.TYPE, Boolean.class.getMethod("valueOf", String.class));
            valueOfMethods.put((Type)((Object)Boolean.class), Boolean.class.getMethod("valueOf", String.class));
            valueOfMethods.put(Byte.TYPE, Byte.class.getMethod("valueOf", String.class));
            valueOfMethods.put((Type)((Object)Byte.class), Byte.class.getMethod("valueOf", String.class));
            valueOfMethods.put((Type)((Object)String.class), String.class.getMethod("valueOf", Object.class));
            valueOfMethods.put(Character.TYPE, ValueUtil.class.getMethod("getCharacter", String.class));
            valueOfMethods.put((Type)((Object)Character.class), ValueUtil.class.getMethod("getCharacter", String.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valueOfMethods;
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        list.add("3");
        System.out.println(ValueUtil.valueOf(list, Integer.TYPE));
        System.out.println(ValueUtil.valueOf(list, Short.TYPE));
        System.out.println(Arrays.toString((Object[])ValueUtil.valueOfToArray(list, REF_ARRAY_INTEGER)));
    }

    public static <T> Object toArray(Collection<T> coll, Class<T> clazz) {
        Object result = Array.newInstance(clazz, coll.size());
        int i = 0;
        for (T obj : coll) {
            Array.set(result, i++, obj);
        }
        return result;
    }

    public static <T> T[] toArray(Collection<T> coll, T[] refArray) {
        Object result = Array.newInstance(refArray.getClass().getComponentType(), coll.size());
        int i = 0;
        for (T obj : coll) {
            Array.set(result, i++, obj);
        }
        return (Object[])result;
    }

    public static <T> Collection<T> valueOf(Collection<String> strList, Class<T> componentClazz) {
        Method method = ValueUtil.getValueOfMethod(componentClazz);
        if (strList == null || strList.size() == 0) {
            return Collections.emptyList();
        }
        try {
            Collection result = (Collection)strList.getClass().newInstance();
            for (String a : strList) {
                try {
                    result.add(method.invoke(null, a));
                }
                catch (Exception e) {}
            }
            return result;
        }
        catch (Exception e1) {
            return Collections.emptyList();
        }
    }

    public static <T> Collection<T> valueOf(Collection<String> strList, Class<T> componentClazz, Collection<T> result) {
        Method method = ValueUtil.getValueOfMethod(componentClazz);
        if (strList != null) {
            for (String a : strList) {
                try {
                    result.add(method.invoke(null, a));
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static <T> T valueOf(Object obj, Class<T> destClazz) throws Exception {
        Method method = ValueUtil.getValueOfMethod(destClazz);
        return (T)method.invoke(null, obj.toString());
    }

    public static <T> T valueOf(Object obj, Class<T> destClazz, T defaultValue) {
        try {
            return ValueUtil.valueOf(obj, destClazz);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <T> Object valueOfToArray(Collection<String> strList, Class<T> componentClazz) {
        return ValueUtil.toArray(ValueUtil.valueOf(strList, componentClazz, new ArrayList(strList.size())), componentClazz);
    }

    public static <T> T[] valueOfToArray(Collection<String> strList, T[] refArray) {
        return ValueUtil.toArray(ValueUtil.valueOf(strList, refArray.getClass().getComponentType(), new ArrayList(strList.size())), refArray);
    }

    private ValueUtil() {
    }
}

