/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.beans.BeanUtils;

public class ReflectConvention {
    public static final boolean SPRING_ENABLE = ReflectConvention.isClassFound("org.springframework.beans.BeanUtils");

    public static Method buildGetterMethod(Class<?> clazz, Field field) throws SecurityException, NoSuchMethodException {
        if (SPRING_ENABLE) {
            String fieldName = field.getName();
            PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(clazz, (String)fieldName);
            if (pd == null) {
                throw new NoSuchMethodException(clazz.getName() + "." + fieldName);
            }
            return pd.getReadMethod();
        }
        String prefix = "get";
        if (field.getType().equals(Boolean.TYPE)) {
            prefix = "is";
        }
        String getterStr = prefix + ReflectConvention.capitalize(field.getName());
        return clazz.getDeclaredMethod(getterStr, new Class[0]);
    }

    public static Method buildSetterMethod(Class<?> clazz, Field field, Class<?> parameterType) throws SecurityException, NoSuchMethodException {
        if (SPRING_ENABLE) {
            String fieldName = field.getName();
            PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(clazz, (String)fieldName);
            if (pd == null) {
                throw new NoSuchMethodException(clazz.getName() + "." + fieldName);
            }
            return pd.getWriteMethod();
        }
        String getterStr = "set" + ReflectConvention.capitalize(field.getName());
        return clazz.getDeclaredMethod(getterStr, parameterType);
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) throws Exception {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            try {
                field = clazz.getField(fieldName);
            }
            catch (NoSuchFieldException ex) {
                if (clazz.getSuperclass() == null) {
                    throw ex;
                }
                field = ReflectConvention.getDeclaredField(clazz.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... classes) throws Exception {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, classes);
        }
        catch (NoSuchMethodException e) {
            try {
                method = clazz.getMethod(methodName, classes);
            }
            catch (NoSuchMethodException ex) {
                if (clazz.getSuperclass() == null) {
                    throw ex;
                }
                method = ReflectConvention.getDeclaredMethod(clazz.getSuperclass(), methodName, classes);
            }
        }
        return method;
    }

    public static Object getValue(Object data, Field field) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = ReflectConvention.buildGetterMethod(field.getDeclaringClass(), field);
        return method.invoke(data, new Object[0]);
    }

    public static boolean isClassFound(String clazzName) {
        try {
            Class.forName(clazzName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isClassFound(String ... clazzNames) {
        try {
            for (String clazzName : clazzNames) {
                Class.forName(clazzName);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void setValue(Object data, Field field, Object value) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = field.getDeclaringClass();
        Method method = ReflectConvention.buildSetterMethod(clazz, field, field.getType());
        method.invoke(data, value);
    }

    private ReflectConvention() {
    }

    static {
        if (!SPRING_ENABLE) {
            System.err.println("ReflectConvention.SPRING_ENABLE=false");
        }
    }
}

