/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import com.xunlei.netty.httpserver.exception.ClosedChannelError;
import com.xunlei.netty.httpserver.exception.ProcessFinishedError;
import com.xunlei.netty.httpserver.util.CloseableHelper;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.netty.httpserver.util.Log;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.slf4j.Logger;

public class NetUtil {
    private static Logger log = Log.getLogger();
    private static String resetByPeerFilterStr = "reset by";
    private static String resetByPeerFilterStr1 = "\u5f3a\u8feb\u5173\u95ed";
    private static String connectionTimedOut = "Connection timed out";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void checkSocketPortBind(boolean exitWhenError, int ... ports) {
        block8: {
            if (!System.getProperty("os.name").startsWith("Win")) break block8;
            for (int port : ports) {
                if (port <= 0) continue;
                boolean isBind = true;
                Socket socket = null;
                try {
                    socket = new Socket("localhost", port);
                }
                catch (ConnectException e1) {
                    isBind = false;
                    CloseableHelper.closeSilently(socket);
                }
                catch (Exception e12) {
                    log.error("", (Throwable)e12);
                    isBind = true;
                    {
                        catch (Throwable throwable) {
                            CloseableHelper.closeSilently(socket);
                            throw throwable;
                        }
                    }
                    CloseableHelper.closeSilently(socket);
                }
                CloseableHelper.closeSilently(socket);
                if (!isBind) continue;
                String errStr = "Failed to bind to " + port;
                if (exitWhenError) {
                    System.err.println(errStr);
                    HttpServerConfig.ALARMLOG.error(errStr);
                    System.exit(1);
                    continue;
                }
                throw new RuntimeException(errStr);
            }
        }
    }

    public static void checkSocketPortBind(int ... ports) {
        NetUtil.checkSocketPortBind(false, ports);
    }

    public static boolean exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        return NetUtil.exceptionCaught(ctx, e, "");
    }

    public static boolean exceptionCaught(ChannelHandlerContext ctx, Throwable t, String type) throws Exception {
        boolean channelInterrupt = false;
        try {
            Object v;
            Channel channel = ctx.getChannel();
            Object attach = ctx.getAttachment();
            Object object = v = attach == null ? channel : attach;
            if (t != null) {
                if (t instanceof IOException && t.getMessage() != null) {
                    String msg = t.getMessage();
                    if (msg.contains(resetByPeerFilterStr) || msg.contains(resetByPeerFilterStr1)) {
                        log.debug("resetByPeer       {}:{},{}", new Object[]{type, v, msg});
                    } else if (msg.contains(connectionTimedOut)) {
                        log.debug("connectionTimeout {}:{},{}", new Object[]{type, v, msg});
                    }
                } else if (t instanceof ClosedChannelException || t instanceof ClosedChannelError) {
                    log.debug("channelClosed     {}:{},{}", new Object[]{type, v, t.getMessage()});
                    channelInterrupt = true;
                } else if (!(t instanceof ProcessFinishedError)) {
                    log.error("exceptionCaught   {}:{}", new Object[]{type, v, t});
                }
            } else {
                log.error("exceptionCaught  {}:{}", new Object[]{type, v, t});
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return channelInterrupt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e, String type) throws Exception {
        try {
            boolean bl = NetUtil.exceptionCaught(ctx, e.getCause(), type);
            return bl;
        }
        finally {
            ctx.sendUpstream((ChannelEvent)e);
        }
    }
}

