/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.exception.IpAuthError;
import com.xunlei.netty.httpserver.util.HttpUtil;
import com.xunlei.netty.httpserver.util.IPGetterHelper;
import com.xunlei.netty.httpserver.util.Log;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class IPAuthenticator {
    private static final Logger log = Log.getLogger();
    private static Set<String> WHITE_LIST_ALL = Collections.emptySet();
    private static Set<String> WHITE_LIST_CONTAINS = Collections.emptySet();
    private static Set<String> WHITE_LIST_MATCH = Collections.emptySet();
    private static final String SPLIT = ",";
    private static final String GLOBAL_WHITE_IP = "219.133.170.82,192.168.*.*";
    private static String businessWhiteIp = "";
    public static boolean LOCALHOST_PASS = true;

    public static void auth(XLHttpRequest request) throws IpAuthError {
        IPAuthenticator.auth(IPGetterHelper.getRequestIp(request));
    }

    public static void auth(String ip) throws IpAuthError {
        if (WHITE_LIST_CONTAINS.contains(ip)) {
            return;
        }
        if (WHITE_LIST_MATCH.size() > 0) {
            for (String ipMath : WHITE_LIST_MATCH) {
                ipMath = ipMath.replace(".", "\\.");
                ipMath = ipMath.replace("*", "(.*)");
                Pattern p = Pattern.compile("^" + ipMath + "$", 2);
                Matcher m = p.matcher(ip);
                if (!m.matches()) continue;
                return;
            }
        }
        throw IpAuthError.INSTANCE;
    }

    public static String getIPWhiteList() {
        return WHITE_LIST_ALL.toString();
    }

    public static void reload() {
        String ipStr;
        LinkedHashSet<String> containsWhiteIpList = new LinkedHashSet<String>();
        LinkedHashSet<String> matchWhiteIpList = new LinkedHashSet<String>();
        if (LOCALHOST_PASS) {
            containsWhiteIpList.addAll(HttpUtil.getLocalIP());
            containsWhiteIpList.add("127.0.0.1");
        }
        if (StringUtils.isNotBlank((String)(ipStr = "219.133.170.82,192.168.*.*," + businessWhiteIp))) {
            for (String ip : StringUtils.split((String)ipStr, (String)SPLIT)) {
                if (!StringUtils.isNotBlank((String)ip)) continue;
                if ((ip = ip.trim()).contains("*")) {
                    matchWhiteIpList.add(ip);
                    continue;
                }
                containsWhiteIpList.add(ip);
            }
        }
        WHITE_LIST_CONTAINS = containsWhiteIpList;
        WHITE_LIST_MATCH = matchWhiteIpList;
        WHITE_LIST_ALL = new LinkedHashSet<String>();
        WHITE_LIST_ALL.addAll(matchWhiteIpList);
        WHITE_LIST_ALL.addAll(containsWhiteIpList);
    }

    public static String getBusinessWhiteIp() {
        return businessWhiteIp;
    }

    public static void setBusinessWhiteIp(String businessWhiteIp) {
        IPAuthenticator.businessWhiteIp = businessWhiteIp;
    }
}

