/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class HumanReadableUtil {
    private static final double[] BYTE_SIZE = new double[]{1.0, 1024.0, 1048576.0, 1.073741824E9, 1.099511627776E12};
    private static final String[] BYTE_SIZE_FORMAT = new String[]{"B", "KB", "MB", "GB", "TB"};
    private static final double[] BYTE_SIZE_HD = new double[]{1.0, 1000.0, 1000000.0, 1.0E9, 1.0E12};
    private static final double[] BYTE_SIZE_THRESHOLD = new double[]{1.0, 999.0, 1022976.0, 1.047527424E9, 1.072668082176E12};
    private static final String NA = "N/A";
    private static final long[] TIME_SPAN = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L, 31536000000L};
    private static final String[] TIME_SPAN_FORMAT_CH = new String[]{"\u6beb\u79d2", "\u79d2", "\u5206", "\u65f6", "\u5929", "\u5e74"};
    private static final String[] TIME_SPAN_FORMAT_EN = new String[]{"ms ", "sec ", "min ", "hour ", "day ", "year "};

    public static String byteSize(long size) {
        return HumanReadableUtil.byteSize(size, false);
    }

    public static String byteSize(long bytes, boolean byHDStandard) {
        if (bytes < 0L) {
            return NA;
        }
        double[] byte_size = BYTE_SIZE;
        double[] byte_size_threadshold = BYTE_SIZE_THRESHOLD;
        if (byHDStandard) {
            byte_size = BYTE_SIZE_HD;
            byte_size_threadshold = BYTE_SIZE_HD;
        }
        int i = 5;
        DecimalFormat df = new DecimalFormat("##.##");
        while (--i >= 0) {
            if (!((double)bytes >= byte_size_threadshold[i])) continue;
            return df.format((double)bytes / byte_size[i]) + BYTE_SIZE_FORMAT[i];
        }
        return "";
    }

    public static String timeSpan(long span) {
        return HumanReadableUtil.timeSpan(span, 0, false);
    }

    public static String timeSpan(long span, int max_len, boolean chinese) {
        String[] format;
        long sp = span;
        int maxlen = max_len;
        if (sp < 0L) {
            return NA;
        }
        String[] stringArray = format = chinese ? TIME_SPAN_FORMAT_CH : TIME_SPAN_FORMAT_EN;
        if (maxlen <= 0) {
            maxlen = 3;
        }
        long tmp = 0L;
        int index = 6;
        StringBuilder sb = new StringBuilder("");
        while (--index >= 0) {
            tmp = sp / TIME_SPAN[index];
            if (tmp <= 0L) continue;
            sp %= TIME_SPAN[index];
            sb.append(tmp);
            sb.append(format[index]);
            if (--maxlen > 0) continue;
            break;
        }
        return sb.toString();
    }

    public static String percentStr(double d, int iDig, int fDig) {
        NumberFormat num = NumberFormat.getPercentInstance();
        num.setMaximumIntegerDigits(iDig);
        num.setMaximumFractionDigits(fDig);
        return num.format(d);
    }

    public static String percentStrSimple(double d) {
        return HumanReadableUtil.percentStr(d, 3, 2);
    }
}

