/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import com.xunlei.netty.httpserver.HttpServerPipelineFactory;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.util.Log;
import com.xunlei.netty.httpserver.util.concurrent.NamedThreadFactory;
import com.xunlei.netty.httpserver.util.spring.AfterConfig;
import com.xunlei.netty.httpserver.util.spring.Config;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.util.internal.ExecutorUtil;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public final class HttpServerConfig {
    public static final Logger ALARMLOG = Log.getLogger("alarm.com.xunlei.netty");
    public static final int CORE_PROCESSOR_NUM = Runtime.getRuntime().availableProcessors();
    private static XLHttpResponse.ContentType respInnerContentType = XLHttpResponse.ContentType.json;
    @Config
    private int listen_port = 80;
    @Config
    private int connectTimeoutMillis = 5000;
    @Config
    private int receiveBufferSize = 8192;
    @Config
    private int sendBufferSize = 8192;
    @Config
    private String indexCmdName = "echo";
    @Config
    private String cmdSuffix = "Cmd";
    @Config
    private String cmdDefaultMethod = "process";
    @Config
    public int workerCount = 0;
    @Config
    private long plMaxChannelMemorySize = 0x6400000L;
    @Config
    private long plMaxTotalMemorySize = 0x40000000L;
    @Config(resetable=true)
    private int plCorePoolSize = CORE_PROCESSOR_NUM * 50;
    @Config(resetable=true)
    private long plKeepAliveSecond = 60L;
    @Config(resetable=true)
    private String plAddBefore = "pageDispatcher";
    @Config(resetable=true)
    private boolean plAddDefalter = false;
    @Config(resetable=true)
    private static long plAddDefalterContentLen = 1024L;
    @Config(resetable=true)
    private String respDefaultContentType = "json";
    @Config(resetable=true)
    private int slowThreshold = 1000;
    @Config(resetable=true)
    private static int keepAliveTimeout = 2;
    @Config(resetable=true)
    private int toleranceTimeout = 10;
    @Config(resetable=true)
    private boolean debugEnable = true;
    @Resource(name="httpServerPipelineFactory")
    private HttpServerPipelineFactory httpServerPipelineFactory;
    @Config(resetable=true)
    private static int asyncProxyPoolChannelCoreNum = 800;
    @Config(resetable=true)
    private static int asyncProxyPoolChannelSwepperDelaySeconds = 60;
    @Config(resetable=true)
    private static String ipWhiteList = "";
    public static final ExecutorService bossExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O server boss $", 10));
    public static final ExecutorService workerExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O server worker $", 9));
    private MemoryAwareThreadPoolExecutor pipelineExecutorUnordered;
    private MemoryAwareThreadPoolExecutor pipelineExecutorOrdered;

    public static long getPlAddDefalterContentLen() {
        return plAddDefalterContentLen;
    }

    @AfterConfig
    public void initPipelineExecutorOrdered() {
        if (this.pipelineExecutorOrdered == null) {
            this.pipelineExecutorOrdered = new OrderedMemoryAwareThreadPoolExecutor(this.plCorePoolSize, this.plMaxChannelMemorySize, this.plMaxTotalMemorySize, this.plKeepAliveSecond, TimeUnit.SECONDS, (ThreadFactory)new NamedThreadFactory("PIPELINE_ORD#", 7));
        } else {
            this.pipelineExecutorOrdered.setCorePoolSize(this.plCorePoolSize);
            this.pipelineExecutorOrdered.setMaximumPoolSize(this.plCorePoolSize);
            this.pipelineExecutorOrdered.setKeepAliveTime(this.plKeepAliveSecond, TimeUnit.SECONDS);
        }
    }

    @AfterConfig
    public void initPipelineExecutorUnordered() {
        if (this.pipelineExecutorUnordered == null) {
            this.pipelineExecutorUnordered = new MemoryAwareThreadPoolExecutor(this.plCorePoolSize, this.plMaxChannelMemorySize, this.plMaxTotalMemorySize, this.plKeepAliveSecond, TimeUnit.SECONDS, (ThreadFactory)new NamedThreadFactory("PIPELINE#", 7));
        } else {
            this.pipelineExecutorUnordered.setCorePoolSize(this.plCorePoolSize);
            this.pipelineExecutorUnordered.setMaximumPoolSize(this.plCorePoolSize);
            this.pipelineExecutorUnordered.setKeepAliveTime(this.plKeepAliveSecond, TimeUnit.SECONDS);
        }
    }

    @AfterConfig
    public void initRespInnerContentType() {
        respInnerContentType = "xml".equalsIgnoreCase(this.respDefaultContentType) ? XLHttpResponse.ContentType.xml : ("html".equalsIgnoreCase(this.respDefaultContentType) ? XLHttpResponse.ContentType.html : ("plain".equalsIgnoreCase(this.respDefaultContentType) ? XLHttpResponse.ContentType.plain : XLHttpResponse.ContentType.json));
    }

    public OrderedMemoryAwareThreadPoolExecutor getPipelineExecutor() {
        return (OrderedMemoryAwareThreadPoolExecutor)this.getPipelineExecutorOrdered();
    }

    public MemoryAwareThreadPoolExecutor getPipelineExecutorUnordered() {
        if (null == this.pipelineExecutorUnordered) {
            this.initPipelineExecutorUnordered();
        }
        return this.pipelineExecutorUnordered;
    }

    public MemoryAwareThreadPoolExecutor getPipelineExecutorOrdered() {
        if (null == this.pipelineExecutorOrdered) {
            this.initPipelineExecutorOrdered();
        }
        return this.pipelineExecutorOrdered;
    }

    public void setPlCorePoolSize(int plCorePoolSize) {
        this.plCorePoolSize = plCorePoolSize;
        this.initPipelineExecutorOrdered();
        this.initPipelineExecutorUnordered();
    }

    public void setPlKeepAliveSecond(long plKeepAliveSecond) {
        this.plKeepAliveSecond = plKeepAliveSecond;
        this.initPipelineExecutorOrdered();
        this.initPipelineExecutorUnordered();
    }

    public int getRealWorkerCount() {
        if (this.workerCount < 0) {
            return CORE_PROCESSOR_NUM * this.workerCount * -1;
        }
        if (this.workerCount == 0) {
            return CORE_PROCESSOR_NUM * 2;
        }
        return this.workerCount;
    }

    public int getListen_port() {
        return this.listen_port;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public int getSlowThreshold() {
        return this.slowThreshold;
    }

    public static int getKeepAliveTimeout() {
        return keepAliveTimeout;
    }

    public int getToleranceTimeout() {
        return this.toleranceTimeout;
    }

    public boolean isDebugEnable() {
        return this.debugEnable;
    }

    public String getIndexCmdName() {
        return this.indexCmdName;
    }

    public String getCmdSuffix() {
        return this.cmdSuffix;
    }

    public String getCmdDefaultMethod() {
        return this.cmdDefaultMethod;
    }

    public String getPlAddBefore() {
        return this.plAddBefore;
    }

    public boolean isPlAddDefalter() {
        return this.plAddDefalter;
    }

    public static XLHttpResponse.ContentType getRespInnerContentType() {
        return respInnerContentType;
    }

    public void setRespDefaultContentType(String respDefaultContentType) {
        this.respDefaultContentType = respDefaultContentType;
        this.initRespInnerContentType();
    }

    public void setPlAddBefore(String plAddBefore) {
        this.plAddBefore = plAddBefore;
        this.httpServerPipelineFactory.rebuildPipeline();
    }

    public void setPlAddDefalter(boolean plAddDefalter) {
        this.plAddDefalter = plAddDefalter;
        this.httpServerPipelineFactory.rebuildPipeline();
    }

    public String getIpWhiteList() {
        return ipWhiteList;
    }

    public static void releaseExternalResources() {
        ExecutorUtil.terminate((Executor[])new Executor[]{bossExecutor, workerExecutor});
    }

    public static int getAsyncProxyPoolChannelCoreNum() {
        return asyncProxyPoolChannelCoreNum;
    }

    public static int getAsyncProxyPoolChannelSwepperDelaySeconds() {
        return asyncProxyPoolChannelSwepperDelaySeconds;
    }
}

