/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import com.dianping.cat.Cat;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.lang.StringUtils;

public class CatLogbackAppender
extends AppenderBase<LoggingEvent> {
    protected void append(LoggingEvent eventObject) {
        boolean isTraceMode = Cat.getManager().isTraceMode();
        Level level = eventObject.getLevel();
        if (level.isGreaterOrEqual(Level.ERROR)) {
            this.logError(eventObject);
        } else if (isTraceMode) {
            this.logTrace(eventObject);
        }
    }

    private void logError(LoggingEvent event) {
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null && throwableProxy instanceof ThrowableProxy) {
            ThrowableProxy tp = (ThrowableProxy)throwableProxy;
            String message = tp.getMessage();
            if (StringUtils.isNotBlank((String)message)) {
                Cat.logError((String)message, (Throwable)tp.getThrowable());
            } else {
                Cat.logError((Throwable)tp.getThrowable());
            }
        }
    }

    private void logTrace(LoggingEvent event) {
        String type = "Logback";
        String name = event.getLevel().toString();
        String data = event.getMessage();
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null && throwableProxy instanceof ThrowableProxy) {
            ThrowableProxy tp = (ThrowableProxy)throwableProxy;
            data = data + '\n' + this.buildExceptionStack(tp.getThrowable());
        }
        Cat.logTrace((String)type, (String)name, (String)"0", (String)data);
    }

    private String buildExceptionStack(Throwable exception) {
        if (exception != null) {
            StringWriter writer = new StringWriter(2048);
            exception.printStackTrace(new PrintWriter(writer));
            return writer.toString();
        }
        return "";
    }
}

