/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.handler;

import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.ProcessTimeoutError;
import com.xunlei.netty.httpserver.exception.ResourceNotFoundError;
import com.xunlei.netty.httpserver.handler.HandlerManager;
import com.xunlei.netty.httpserver.handler.PlainHandler;
import com.xunlei.netty.httpserver.handler.PlainHandlerExt;
import com.xunlei.netty.httpserver.handler.TextResponseHandler;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.netty.httpserver.util.spring.AfterConfig;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Resource;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TextResponseHandlerManager
extends HandlerManager<TextResponseHandler> {
    private static TextResponseHandlerManager INSTANCE;
    @Autowired
    private HttpServerConfig serverConfig;
    @Resource
    private PlainHandler plainHandler;
    @Resource
    private PlainHandlerExt plainHandlerExt;

    public TextResponseHandlerManager() {
        INSTANCE = this;
    }

    public static TextResponseHandlerManager getInstance() {
        return INSTANCE;
    }

    @AfterConfig
    public void initHandlerChain() {
        this.addFirst(this.plainHandlerExt);
        this.addLast(this.plainHandler);
    }

    public String getContentString(XLContextAttachment attach, Object cmdReturnObj) {
        for (TextResponseHandler trh : this.getHandlerChain()) {
            String contentStr = trh.buildContentString(attach, cmdReturnObj);
            if (contentStr == null) continue;
            return contentStr;
        }
        return null;
    }

    private void setContent(XLContextAttachment attach, Object cmdReturnObj) {
        XLHttpResponse response = attach.getResponse();
        if (!response.isContentSetted()) {
            String contentStr = null;
            for (TextResponseHandler trh : this.getHandlerChain()) {
                contentStr = trh.buildContentString(attach, cmdReturnObj);
                if (contentStr == null) continue;
                response.setContentString(contentStr);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(XLContextAttachment attach, Object cmdReturnObj) {
        Channel channel = attach.getChannelHandlerContext().getChannel();
        attach.checkChannelOrThread();
        XLHttpResponse response = attach.getResponse();
        XLHttpRequest request = attach.getRequest();
        this.setContent(attach, cmdReturnObj);
        response.packagingCookies();
        boolean close = attach.setKeepAliveHeader();
        ChannelFuture future = channel.write((Object)response);
        if (close) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public Object handleThrowable(XLContextAttachment attach, Throwable e) throws Exception {
        Object cmdReturnObj = null;
        Throwable ex = e;
        if (ex instanceof NoSuchMethodException || ex instanceof SecurityException) {
            ex = ResourceNotFoundError.INSTANCE;
        } else if (ex instanceof InvocationTargetException) {
            ex = ((InvocationTargetException)ex).getTargetException();
        } else if (ex instanceof InterruptedException) {
            ex = ProcessTimeoutError.INSTANCE;
        }
        attach.registerThrowable(ex);
        for (TextResponseHandler th : this.getHandlerChain()) {
            cmdReturnObj = th.handleThrowable(attach, ex);
            if (cmdReturnObj == null) continue;
            return cmdReturnObj;
        }
        return cmdReturnObj;
    }
}

