/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd.common;

import com.xunlei.netty.httpserver.HttpServerPipelineFactory;
import com.xunlei.netty.httpserver.cmd.BaseStatCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.cmd.CmdMappers;
import com.xunlei.netty.httpserver.cmd.annotation.CmdAdmin;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.util.HtmlUtil;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.netty.httpserver.util.HttpUtil;
import com.xunlei.netty.httpserver.util.IPAuthenticator;
import com.xunlei.netty.httpserver.util.Log;
import com.xunlei.netty.httpserver.util.spring.ConfigBeanPostProcessor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SettingCmd
extends BaseStatCmd {
    private static final Logger log = Log.getLogger();
    @Autowired
    private CmdMappers cmdMappers;
    @Autowired
    private HttpServerConfig config;
    @Autowired
    private ConfigBeanPostProcessor configProcessor;
    @Resource
    private HttpServerPipelineFactory httpServerPipelineFactory;

    @CmdMapper(value={"/robots.txt"})
    @CmdAdmin
    public Object robots(XLHttpRequest request, XLHttpResponse response) throws Exception {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        return "User-agent: *\nDisallow: /\n";
    }

    @CmdAdmin
    public Object cmds(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        boolean useTxt = request.getParameterBoolean("txt", false);
        if (!useTxt) {
            response.setInnerContentType(XLHttpResponse.ContentType.html);
        }
        String tmp = "";
        Map<String, CmdMappers.CmdMeta> cmd_urls_map = this.cmdMappers.getCmdAllMap();
        if (cmd_urls_map != null && cmd_urls_map.size() > 0) {
            ArrayList<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
            for (Map.Entry<String, CmdMappers.CmdMeta> cmdUrlMap : cmd_urls_map.entrySet()) {
                String cmdUrl = cmdUrlMap.getKey();
                CmdMappers.CmdMeta cmdMeta = cmdUrlMap.getValue();
                LinkedHashMap<String, String> mapData = new LinkedHashMap<String, String>();
                mapData.put("url", HtmlUtil.getHtmlLink(cmdUrl));
                mapData.put("name", cmdMeta.toString());
                mapData.put("isAdmin", String.valueOf(cmdMeta.isAdmin()));
                mapData.put("timeout", String.valueOf(cmdMeta.getTimeout()));
                tableData.add(mapData);
            }
            tmp = HtmlUtil.getHtmlTable(tableData);
        }
        return tmp;
    }

    @CmdAdmin
    public Object config(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        return this.configProcessor.printCurrentConfig(new StringBuilder());
    }

    @CmdAdmin
    public Object configHistory(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder();
        return tmp.append((CharSequence)this.configProcessor.getResetHistory());
    }

    @CmdAdmin
    public Object httpServerConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder();
        for (Field f : this.config.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                tmp.append(String.format("%-24s%-10s\n", f.getName() + ":", f.get(this.config)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        tmp.append("\u672c\u5730IP:\t\t\t").append(HttpUtil.getLocalIP()).append("\n");
        tmp.append("IP\u767d\u540d\u5355:\t\t").append(IPAuthenticator.getIPWhiteList()).append("\n");
        try {
            tmp.append("PIPELINE:\t\t").append(this.httpServerPipelineFactory.getPipeline()).append("\n");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            tmp.append(e.getMessage()).append("\n");
        }
        return tmp.toString();
    }

    @CmdAdmin
    public Object reloadConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder();
        this.configProcessor.reloadConfig(tmp);
        return tmp.toString();
    }

    @CmdAdmin
    public Object reloadCmdConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        return null;
    }

    @CmdAdmin
    public Object reloadIpfilter(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        IPAuthenticator.reload();
        return "reset success";
    }

    @CmdAdmin
    public Object resetGuardedConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder("reset guarded config...\n");
        this.configProcessor.resetGuradedConfig(tmp);
        return tmp;
    }

    @CmdAdmin
    public Object setConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder("set tmp config...\n");
        for (Map.Entry<String, List<String>> e : request.getParameters().entrySet()) {
            String fieldName = e.getKey();
            String value = e.getValue().get(0);
            this.configProcessor.setFieldValue(fieldName, value, tmp);
        }
        return tmp.toString();
    }
}

