/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver;

import com.xunlei.netty.httpserver.Bootstrap;
import com.xunlei.netty.httpserver.component.AbstractPageDispatcher;
import com.xunlei.netty.httpserver.component.NOPDispatcher;
import com.xunlei.netty.httpserver.component.XLHttpRequestDecoder;
import com.xunlei.netty.httpserver.component.XLHttpResponseEncoder;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.netty.httpserver.util.Log;
import com.xunlei.netty.httpserver.util.spring.AfterConfig;
import com.xunlei.netty.httpserver.util.spring.Config;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpServerPipelineFactory
implements ChannelPipelineFactory {
    private static final Logger log = Log.getLogger();
    @Autowired
    private Bootstrap bootstrap;
    @Autowired
    private HttpServerConfig config;
    @Config
    private int maxContentLength = 0x100000;
    private HttpResponseEncoder encoder = new XLHttpResponseEncoder();
    private ExecutionHandler executionHandler;
    private IdleStateAwareChannelHandler idleAwareHandler;
    private Timer idleCheckTimer;
    @Autowired
    private NOPDispatcher nopDispatcher;
    @Autowired
    private AbstractPageDispatcher pageDispatcher;

    @AfterConfig
    public void init() {
        this.executionHandler = new ExecutionHandler((Executor)this.config.getPipelineExecutor());
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        log.debug("Netty\u670d\u52a1.Http\u8bf7\u6c42.\u7ba1\u9053\u521d\u59cb\u5316.getPipeline()");
        if (this.bootstrap.isStop()) {
            pipeline.addLast("nop", (ChannelHandler)this.nopDispatcher);
            return pipeline;
        }
        pipeline.addLast("decoder", (ChannelHandler)new XLHttpRequestDecoder(this.config));
        pipeline.addLast("encoder", (ChannelHandler)this.encoder);
        if (this.config.isPlAddDefalter()) {
            pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
        }
        pipeline.addLast("pageDispatcher", (ChannelHandler)this.pageDispatcher);
        String addBefore = this.config.getPlAddBefore();
        if (addBefore != null) {
            if (addBefore.isEmpty()) {
                pipeline.addFirst("executor", (ChannelHandler)this.executionHandler);
            } else {
                try {
                    pipeline.addBefore(addBefore, "executor", (ChannelHandler)this.executionHandler);
                }
                catch (NoSuchElementException e) {
                    log.error("config error,config.plAddBefore:{} NOT FOUND,execption:{}", (Object)addBefore, (Object)e);
                    pipeline.addFirst("executor", (ChannelHandler)this.executionHandler);
                }
            }
        }
        return pipeline;
    }

    public HttpServerPipelineFactory rebuildPipeline() {
        return this;
    }

    public class SimpleIdleStateAwareChannelHandler
    extends IdleStateAwareChannelHandler {
        public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
            log.debug("channel:{},idleState:{}", (Object)e.getChannel(), (Object)e.getState());
            e.getChannel().close();
        }
    }
}

