/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver;

import com.xunlei.netty.httpserver.HttpServerPipelineFactory;
import com.xunlei.netty.httpserver.component.AbstractPageDispatcher;
import com.xunlei.netty.httpserver.util.CloseableHelper;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.netty.httpserver.util.IPAuthenticator;
import com.xunlei.netty.httpserver.util.Log;
import com.xunlei.netty.httpserver.util.NetUtil;
import com.xunlei.netty.httpserver.util.NioSocketBootstrapFactory;
import com.xunlei.netty.httpserver.util.spring.BeanUtil;
import com.xunlei.netty.httpserver.util.spring.Config;
import com.xunlei.netty.httpserver.util.spring.SpringBootstrap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class Bootstrap {
    public static ApplicationContext CONTEXT;
    private static final Logger log;
    private volatile boolean stopping = false;
    private ExecutorService bossExecutor = HttpServerConfig.bossExecutor;
    private Runnable shutdownRunanble = null;
    @Resource
    private HttpServerPipelineFactory httpServerPipelineFactory;
    @Autowired
    private HttpServerConfig config;
    @Autowired
    private AbstractPageDispatcher pageDispatcher;
    private NioServerSocketChannelFactory serverSocketChannelFactory;
    private ExecutorService workerExecutor = HttpServerConfig.workerExecutor;
    @Config
    private long bindRetryTimeout = 60000L;

    public static boolean isArgWhat(String[] args, String ... what) {
        if (args == null || args.length == 0) {
            return false;
        }
        String arg = args[0].toLowerCase();
        for (String w : what) {
            if (arg.indexOf(w) < 0) continue;
            return true;
        }
        return false;
    }

    public static ApplicationContext main(String[] args, Runnable initialRunnable, Runnable shutdownRunnalbe, String ... springConfigLocations) throws IOException {
        log.debug("Netty\u670d\u52a1.\u670d\u52a1Main\u8fd0\u884c");
        long before = System.currentTimeMillis();
        try {
            CONTEXT = SpringBootstrap.load(springConfigLocations);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        System.err.println("----->loadContext      [" + (System.currentTimeMillis() - before) + "MS]");
        Bootstrap bootstrap = (Bootstrap)BeanUtil.getTypedBean("bootstrap");
        bootstrap.shutdownRunanble = shutdownRunnalbe;
        if (Bootstrap.isArgWhat(args, "stop", "shutdown")) {
            log.debug("Netty\u670d\u52a1.\u670d\u52a1\u5173\u95ed");
            bootstrap.sendShutdownCmd();
            System.exit(0);
        } else {
            log.debug("Netty\u670d\u52a1.\u670d\u52a1\u542f\u52a8");
            if (!Bootstrap.isArgWhat(args, "compelled", "force")) {
                bootstrap.bindRetryTimeout = 0L;
            }
            bootstrap.start(initialRunnable);
        }
        return CONTEXT;
    }

    public static ApplicationContext main(String[] args, Runnable initialRunnable, String ... springConfigLocations) throws IOException {
        return Bootstrap.main(args, initialRunnable, null, springConfigLocations);
    }

    public static ApplicationContext main(String[] args, String ... springConfigLocations) throws IOException {
        return Bootstrap.main(args, null, null, springConfigLocations);
    }

    private void initEnv() {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
        IPAuthenticator.setBusinessWhiteIp(this.config.getIpWhiteList());
        IPAuthenticator.reload();
    }

    private void initOutter(Runnable initialRunnable) {
        if (initialRunnable != null) {
            long before = System.currentTimeMillis();
            try {
                initialRunnable.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(-1);
            }
            System.err.println("----->initialRunnable  [" + (System.currentTimeMillis() - before) + "MS]");
        }
    }

    private ServerBootstrap initServerBootstrap(HttpServerPipelineFactory channelPipelineFactory) {
        ServerBootstrap serverBootstrap = new ServerBootstrap((ChannelFactory)this.serverSocketChannelFactory);
        serverBootstrap.setPipelineFactory((ChannelPipelineFactory)channelPipelineFactory.rebuildPipeline());
        NioSocketBootstrapFactory.setBootstrapOptions((org.jboss.netty.bootstrap.Bootstrap)serverBootstrap, this.config.getConnectTimeoutMillis(), this.config.getReceiveBufferSize(), this.config.getSendBufferSize());
        return serverBootstrap;
    }

    private void bind(int port, ServerBootstrap serverBootstrap) {
        if (port > 0) {
            serverBootstrap.bind((SocketAddress)new InetSocketAddress(port));
        }
    }

    private void initServer() {
        this.serverSocketChannelFactory = new NioServerSocketChannelFactory((Executor)this.bossExecutor, (Executor)this.workerExecutor, this.config.getRealWorkerCount());
        int port = this.config.getListen_port();
        String ports = port + "";
        Exception ex = null;
        try {
            ServerBootstrap serverBootstrap = this.initServerBootstrap(this.httpServerPipelineFactory);
            long beginBind = System.currentTimeMillis();
            NetUtil.checkSocketPortBind(port);
            this.bind(port, serverBootstrap);
            long endBind = System.currentTimeMillis();
            System.err.println("----->bindHttpPort     [" + (endBind - beginBind) + "MS]");
        }
        catch (Exception e) {
            ex = e;
        }
        long span = System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getStartTime();
        String msg = ex == null ? "OK" : "ERROR";
        String chnmsg = ex == null ? "\u670d\u52a1\u5668\u542f\u52a8\u5b8c\u6bd5.(port[" + ports + "])" : "\u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25.(port[" + this.config.getListen_port() + "])";
        String spanStr = "[" + span + "MS]";
        String errStr = ex == null ? "" : ex.getMessage();
        HttpServerConfig.ALARMLOG.error("HTTPServer(port[{}],workerCount[{}]) Start {}.{}", new Object[]{ports, this.config.getRealWorkerCount(), msg, spanStr, ex});
        System.err.println(chnmsg + spanStr + errStr);
        log.debug("Netty\u670d\u52a1.\u521d\u59cb\u5316\u670d\u52a1." + chnmsg + spanStr + errStr);
        if (ex != null) {
            System.exit(1);
        }
    }

    public void start(Runnable initialRunnable) throws IOException {
        log.debug("Netty\u670d\u52a1.\u521d\u59cb\u5316\u73af\u5883.initEnv()");
        this.initEnv();
        log.debug("Netty\u670d\u52a1.\u521d\u59cb\u5316\u4e1a\u52a1\u63a5\u53e3.pageDispatcher.init()");
        try {
            this.pageDispatcher.init();
        }
        catch (Exception e) {
            log.error("Netty\u670d\u52a1.\u521d\u59cb\u5316\u4e1a\u52a1\u63a5\u53e3.\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        log.debug("Netty\u670d\u52a1.\u521d\u59cb\u5316\u5916\u90e8\u903b\u8f91.initOutter()");
        this.initOutter(initialRunnable);
        log.debug("Netty\u670d\u52a1.\u521d\u59cb\u5316\u670d\u52a1.initServer");
        this.initServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendShutdownCmd() {
        block8: {
            long l;
            LineNumberReader lineReader;
            block7: {
                HttpURLConnection urlConnection = null;
                lineReader = null;
                try {
                    String tmp;
                    URL url = new URL("http://localhost:" + this.config.getListen_port() + "/shutdown");
                    urlConnection = (HttpURLConnection)url.openConnection();
                    urlConnection.setReadTimeout(10000);
                    lineReader = new LineNumberReader(new InputStreamReader(urlConnection.getInputStream()));
                    StringBuilder sb = new StringBuilder();
                    while ((tmp = lineReader.readLine()) != null) {
                        sb.append(tmp);
                    }
                    String returnStr = sb.toString();
                    log.error("shutdown last result:{}", (Object)returnStr);
                    l = Long.valueOf(returnStr);
                    if (urlConnection == null) break block7;
                    urlConnection.disconnect();
                    urlConnection = null;
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                    break block8;
                }
                finally {
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                        urlConnection = null;
                    }
                    CloseableHelper.closeSilently(lineReader);
                }
            }
            CloseableHelper.closeSilently(lineReader);
            return l;
        }
        return 0L;
    }

    public void stop() {
        this.stopping = true;
        String msg = null;
        this.httpServerPipelineFactory.rebuildPipeline();
        if (this.shutdownRunanble != null) {
            long before = System.currentTimeMillis();
            msg = "shutdownRunanble run begin...";
            log.error(msg);
            System.err.println(msg);
            this.shutdownRunanble.run();
            msg = "shutdownRunanble run end,USING " + (System.currentTimeMillis() - before) + " MS";
            log.error(msg);
            System.err.println(msg);
        }
    }

    public boolean isStop() {
        return this.stopping;
    }

    static {
        log = Log.getLogger();
    }
}

