package com.xunlei.netty.httpserver.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.xunlei.netty.httpserver.cmd.BaseCmd;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.exception.IpAuthError;

/**
 * @author ZengDong
 * @since 2010-5-22 上午01:13:09
 */
public class IPAuthenticator {

	private static final Logger log = Log.getLogger();
	/**
	 * 所有白名单
	 */
	private static Set<String> WHITE_LIST_ALL = Collections.emptySet();
	/**
	 * 可直接匹配的白名单
	 */
	private static Set<String> WHITE_LIST_CONTAINS = Collections.emptySet();
	/**
	 * 需要正则匹配的白名单
	 */
	private static Set<String> WHITE_LIST_MATCH = Collections.emptySet();
	/**
	 * Ip地址分隔符
	 */
	private static final String SPLIT = ",";
	/**
	 * 全局白名单IP
	 */
	private static final String GLOBAL_WHITE_IP = "219.133.170.82,192.168.*.*";//219.133.170.82：办公环境对外地址。192.168.*.*：
	/**
	 * 业务白名单IP
	 */
	private static String businessWhiteIp = "";
	public static boolean LOCALHOST_PASS = true;

	/**
	 * Ip权限验证
	 * 
	 * @param request
	 * @throws IpAuthError
	 */
	public static void auth(XLHttpRequest request) throws IpAuthError {
		auth(IPGetterHelper.getRequestIp(request));
	}

	/**
	 * IP权限验证
	 * @param ip
	 * @throws IpAuthError
	 */
	public static void auth(String ip) throws IpAuthError {
		//直接匹配
		if(WHITE_LIST_CONTAINS.contains(ip))
			return;
		//正则匹配
		if(WHITE_LIST_MATCH.size() > 0){
			for (String ipMath : WHITE_LIST_MATCH) {
				ipMath = ipMath.replace(".", "\\.");
				ipMath = ipMath.replace("*", "(.*)");// 加上小括号,方便查看
				Pattern p = Pattern.compile("^" + ipMath + "$", Pattern.CASE_INSENSITIVE);
				Matcher m = p.matcher(ip);
				if(m.matches() == true)
					return;
			}
		}
		throw IpAuthError.INSTANCE;
	}

	/**
	 * 获取IP白名单列表
	 * @return
	 */
	public static String getIPWhiteList() {
		return WHITE_LIST_ALL.toString();
	}

	/**
	 * 加载配置
	 * @param localhostPass
	 */
	public static void reload() {
		Set<String> containsWhiteIpList = new LinkedHashSet<String>();
		Set<String> matchWhiteIpList = new LinkedHashSet<String>();
		if (LOCALHOST_PASS) {
			containsWhiteIpList.addAll(HttpUtil.getLocalIP());
			containsWhiteIpList.add("127.0.0.1");
		}
		String ipStr = GLOBAL_WHITE_IP + SPLIT + businessWhiteIp;
		// 白名单
		if (StringUtils.isNotBlank(ipStr)) {
			for (String ip : StringUtils.split(ipStr, SPLIT)) {
				if (StringUtils.isNotBlank(ip)) {
					ip = ip.trim();
					if(ip.contains("*")){
						matchWhiteIpList.add(ip);
					}else{
						containsWhiteIpList.add(ip);
					}
				}
			}
		}
		WHITE_LIST_CONTAINS = containsWhiteIpList;
		WHITE_LIST_MATCH = matchWhiteIpList;
		WHITE_LIST_ALL = new LinkedHashSet<String>(); 
		WHITE_LIST_ALL.addAll(matchWhiteIpList);
		WHITE_LIST_ALL.addAll(containsWhiteIpList);
	}

	/**
	 * @return 业务白名单
	 */
	public static String getBusinessWhiteIp() {
		return businessWhiteIp;
	}

	/**
	 * @param businessWhiteIp 业务白名单
	 */
	public static void setBusinessWhiteIp(String businessWhiteIp) {
		IPAuthenticator.businessWhiteIp = businessWhiteIp;
	}
}
