/**
 * 
 */
package com.xunlei.netty.httpserver.component;

import java.util.Date;

/**
 * ChannelHandler信息
 * 
 * @author wangcanyi
 *
 */
public class XLChannelHandlerInfo {
	private XLChannelHandlerEnum channelHandlerEnum;
	private Date startTime;
	private Date endTime;
	private long intervalTime;

	/**
	 * @return ChannelHandler枚举
	 */
	public XLChannelHandlerEnum getChannelHandlerEnum() {
		return channelHandlerEnum;
	}

	/**
	 * @param channelHandlerEnum ChannelHandler枚举
	 */
	public void setChannelHandlerEnum(XLChannelHandlerEnum channelHandlerEnum) {
		this.channelHandlerEnum = channelHandlerEnum;
	}

	/**
	 * @return 开始时间
	 */
	public Date getStartTime() {
		return startTime;
	}

	/**
	 * @param startTime 开始时间
	 */
	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	/**
	 * @return 结束时间
	 */
	public Date getEndTime() {
		return endTime;
	}

	/**
	 * @param endTime 结束时间
	 */
	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	/**
	 * @return 间隔时间
	 */
	public long getIntervalTime() {
		intervalTime = 0;
		if (this.startTime != null && this.endTime != null)
			intervalTime = this.endTime.getTime() - this.startTime.getTime();
		return intervalTime;
	}
}
