package com.xunlei.netty.httpserver.cmd.common;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

import com.xunlei.netty.httpserver.cmd.BaseStatCmd;
import com.xunlei.netty.httpserver.cmd.annotation.CmdAdmin;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.util.Log;
import com.xunlei.netty.httpserver.util.SystemInfo;

/**
 * <pre>
 *  请求次数: 55
 *  响应次数: 53
 *  通道提前关闭: 5
 *  请求次数 - 响应次数 = 通道提前关闭 - ClosedChannelError(提前检查到通道关闭的次数)
 * 
 *  通道打开次数: 77
 *  通道关闭次数: 76
 *  当前打开通道: 1
 *  服务器清除通道: 0
 *  当前打开通道 = 通道打开次数 - 通道关闭次数
 *  客户端或服务器端 正常关闭次数 = 通道关闭次数 - 服务器清除通道
 *  
 *  401IP受限: 0           ip过滤不通过的次数,ipfilter
 *  403禁止访问: 26        favicon.ico请求的次数
 *  404未找到: 0           找不到cmd类或方法的次数
 *  408处理超时: 0         内部future.get(toleranceTimeout)超时的次数
 *  500内部错误: 0         业务处理错误次数
 * </pre>
 * 
 * <pre>
 * 开始解码     attach.decode           (req.createTime)        
 *                                  } 解码用时
 * 开始业务处理   attach.process          (resp.createTime)
 *                                  } 业务处理用时
 * 开始编码     attach.encode
 *                                  } 编码用时
 * 发送完成     attach.complete
 * </pre>
 * 
 * @author ZengDong
 * @since 2010-5-20 下午03:34:28
 */
@Service
public class StatCmd extends BaseStatCmd {
    private static final Logger log = Log.getLogger();
    @CmdAdmin
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        init(request, response);
        StringBuilder tmp = new StringBuilder();
        tmp.append(SystemInfo.getSytemInfo());
        return tmp.toString();
    }
}
