/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.http;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;

public class ClientFactory {
    public static final int DEFAULT_TIMEOUT = 6000;
    private static ConnectionKeepAliveStrategy myStrategy = new DefaultConnectionKeepAliveStrategy(){

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            long keepAliveDuration = super.getKeepAliveDuration(response, context);
            if (keepAliveDuration == -1L) {
                return 60000L;
            }
            return keepAliveDuration;
        }
    };

    public static CloseableHttpClient newClient(int timeout) {
        if (timeout <= 0) {
            timeout = 6000;
        }
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setSocketTimeout(timeout);
        requestBuilder.setConnectTimeout(timeout);
        requestBuilder.setConnectionRequestTimeout(timeout);
        CloseableHttpClient client = HttpClientBuilder.create().setMaxConnTotal(200).setMaxConnPerRoute(20).setDefaultRequestConfig(requestBuilder.build()).setKeepAliveStrategy(myStrategy).build();
        return client;
    }

    private static HttpClient newClient() {
        return ClientFactory.newClient(6000);
    }

    private ClientFactory() {
    }

    public static HttpClient getClient() {
        return InstanceHolder.INSTANCE;
    }

    static /* synthetic */ HttpClient access$000() {
        return ClientFactory.newClient();
    }

    private static class InstanceHolder {
        private static final HttpClient INSTANCE = ClientFactory.access$000();

        private InstanceHolder() {
        }
    }
}

