/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.encrypt;

import com.xunlei.channel.common.utils.encrypt.RSA;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.UrlBase64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSASignature
extends RSA {
    private static final Logger LOG = LoggerFactory.getLogger(RSASignature.class);
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA1WithRSA";
    public static final String ENCODING = "utf-8";
    public static final String X509 = "X.509";

    public static String signByPrivateKey(String content, String privateKey) {
        try {
            PrivateKey priKey = RSASignature.getPrivateKey(privateKey);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(priKey);
            signature.update(content.getBytes(ENCODING));
            byte[] signed = signature.sign();
            return new String(UrlBase64.encode((byte[])signed), ENCODING);
        }
        catch (Exception e) {
            LOG.error("sign error, content: {}, priKey: {}", new Object[]{content, privateKey});
            LOG.error("sign error", (Throwable)e);
            return null;
        }
    }

    public static boolean verifySignByPublicKey(String content, String sign, String publicKey) {
        try {
            PublicKey pubKey = RSASignature.getPublicKey(publicKey);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(ENCODING));
            return signature.verify(UrlBase64.decode((byte[])sign.getBytes(ENCODING)));
        }
        catch (Exception e) {
            LOG.error("sign error, content: {}, sign: {}, pubKey: {}", new Object[]{content, sign, publicKey});
            LOG.error("sign error", (Throwable)e);
            return false;
        }
    }

    public static boolean verifySignByPublicKey(String content, String sign, String publicKey, String encoding) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            byte[] encodedKey = Base64.decode((byte[])publicKey.getBytes(encoding));
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(encoding));
            return signature.verify(UrlBase64.decode((byte[])sign.getBytes(encoding)));
        }
        catch (Exception e) {
            LOG.error("sign error, content: {}, sign: {}, pubKey: {}", new Object[]{content, sign, publicKey});
            LOG.error("sign error", (Throwable)e);
            return false;
        }
    }
}

